--- !!!!! After running this script please run the INSERT_FAC_SUPPORTED_TYPES.sql, if there was an error running the reference in here.
--- This script will update the db, inorder to support logging of the document spec type.  Document spec type is used to determine what specification was used to create a document.  This will also add the capability to determine what document types a partner can receive.  The queryname column is used for document creation.  Query names for HITSP documents are just the LOINC code.  QUERY names for other spec version should follow the format "LOINC-FIRST letter spec name".  Query names must match the querynames established in the datamanagerConfig.xml.
--- **************   Start VA Types *******************

spool SupportedDocumentTypes.log

CREATE SEQUENCE ADAPTER.VA_TYPES_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.VA_TYPES
(
	VA_TYPE_ID NUMBER NOT NULL,
	LOINC_CODE VARCHAR2(10 BYTE), 
	LOINC_DESC VARCHAR2(255 BYTE),
	DOC_SPEC_TYPE VARCHAR2(20 BYTE), 
	QUERYNAME VARCHAR2(30 BYTE)
) TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.VA_TYPES_PK ON ADAPTER.VA_TYPES
(VA_TYPE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.VA_TYPES_TRG
BEFORE INSERT
ON ADAPTER.VA_TYPES
FOR EACH ROW
BEGIN
    :new.VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.nextval;
END VA_TYPES_TRG;
/

ALTER TABLE ADAPTER.VA_TYPES ADD (
  CONSTRAINT VA_TYPES_PK
  PRIMARY KEY
  (VA_TYPE_ID)
  USING INDEX ADAPTER.VA_TYPES_PK
  ENABLE VALIDATE);

 --- Add Data ---
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('34133-9','HITSP 2.5','Summarization of episode note','34133-9');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('34133-9','C-CDA R1.1','Summarization of episode note','34133-9-C');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('18842-5','HITSP 2.5','Discharge summarization note','18842-5');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('11488-4','HITSP 2.5','Consultation note','11488-4');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('34117-2','HITSP 2.5','History and physical note','34117-2');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('28570-0','HITSP 2.5','Procedure note','28570-0');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('29752-3','HITSP 2.5','Perioperative records','29752-3');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('18726-0','HITSP 2.5','Radiology studies','18726-0');
 INSERT INTO ADAPTER.VA_TYPES (LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME) VALUES ('27898-6','HITSP 2.5','Pathology studies','27898-6');

 --- End Add Data --- 

--- **************   End VA Types *******************
--- **************   Start Facility Supported Types  *************************

CREATE SEQUENCE ADAPTER.FACILITY_SUPPORTED_TYPES_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.FACILITY_SUPPORTED_TYPES
(
	FAC_SUP_ID NUMBER NOT NULL ENABLE, 
	FACILITY_ID NUMBER NOT NULL,
	VA_TYPE_ID NUMBER NOT NULL,
	IS_PREF_TYPE VARCHAR2(1 BYTE) DEFAULT 'Y' NOT NULL,
	FOREIGN KEY (FACILITY_ID) REFERENCES ADAPTER.FACILITIES(FACILITY_ID) ON DELETE CASCADE,
	FOREIGN KEY (VA_TYPE_ID) REFERENCES ADAPTER.VA_TYPES(VA_TYPE_ID) ON DELETE CASCADE
)  TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.FACILITY_SUPPORTED_TYPES_PK ON ADAPTER.FACILITY_SUPPORTED_TYPES
(FAC_SUP_ID);

CREATE OR REPLACE TRIGGER ADAPTER.FAC_SUP_TYPE_ID_TRG
BEFORE INSERT
ON ADAPTER.FACILITY_SUPPORTED_TYPES
FOR EACH ROW
BEGIN
    :new.FAC_SUP_ID := ADAPTER.FACILITY_SUPPORTED_TYPES_SEQ.nextval;
END FAC_SUP_TYPE_ID_TRG;
/

ALTER TABLE ADAPTER.FACILITY_SUPPORTED_TYPES ADD (
  CONSTRAINT FACILITY_SUPPORTED_TYPES_PK
  PRIMARY KEY
  (FAC_SUP_ID)
  USING INDEX ADAPTER.FACILITY_SUPPORTED_TYPES_PK
  ENABLE VALIDATE);
--- **************   End Facility Supported Types  *************************

--- **************   Start Facility Supported Types View *******************

CREATE OR REPLACE FORCE VIEW ADAPTER.FAC_SUP_DOCTYPES
AS
SELECT FAC_SUP_ID, HOME_COMMUNITY_ID, LOINC_CODE, DOC_SPEC_TYPE, LOINC_DESC, QUERYNAME, IS_PREF_TYPE FROM
	((ADAPTER.FACILITY_SUPPORTED_TYPES S INNER JOIN ADAPTER.FACILITIES F ON S.FACILITY_ID = F.FACILITY_ID) INNER JOIN ADAPTER.VA_TYPES V ON S.VA_TYPE_ID = V.VA_TYPE_ID);

--- **************   End Facility Supported Types View   *******************

CREATE OR REPLACE SYNONYM ADAPTER_APP.FACILITY_SUPPORTED_TYPES FOR ADAPTER.FACILITY_SUPPORTED_TYPES;
CREATE OR REPLACE SYNONYM ADAPTER_APP.VA_TYPES FOR ADAPTER.VA_TYPES;
CREATE OR REPLACE SYNONYM ADAPTER_APP.FAC_SUP_DOCTYPES FOR ADAPTER.FAC_SUP_DOCTYPES;
--- **** Update permissions.
GRANT SELECT ON ADAPTER.FACILITY_SUPPORTED_TYPES_SEQ TO ADAPTER_USER;
GRANT INSERT, UPDATE, SELECT, DELETE ON ADAPTER.VA_TYPES TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.VA_TYPES TO ADAPTER_READ;
GRANT INSERT, UPDATE, SELECT, DELETE ON  ADAPTER.FACILITY_SUPPORTED_TYPES TO ADAPTER_USER;
GRANT SELECT ON  ADAPTER.FACILITY_SUPPORTED_TYPES TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.FAC_SUP_DOCTYPES TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.FAC_SUP_DOCTYPES TO ADAPTER_READ;

spool off