--- Creation for all tables required in the Sensitive data filtering requirement.
--- Since Adapter 6.6.0
--- This script will only add the tables it will not create any test data.
--- There are two tables created in this script, SENSITIVE_INFO and NOTES_LIST.

--- **************   Start SENSITIVE_INFO *******************

spool SensitiveFiltering.log

CREATE SEQUENCE ADAPTER.SENSITIVE_INFO_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.SENSITIVE_INFO
(
	INFO_ID NUMBER NOT NULL,
	LOCATION VARCHAR2(255 BYTE), 
	SENS_VALUE VARCHAR2(255 BYTE)
) TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.SENSITIVE_INFO_PK ON ADAPTER.SENSITIVE_INFO
(INFO_ID);



CREATE OR REPLACE TRIGGER ADAPTER.SENSITIVE_INFO_TRG
BEFORE INSERT
ON ADAPTER.SENSITIVE_INFO 
FOR EACH ROW
BEGIN
    :new.INFO_ID := ADAPTER.SENSITIVE_INFO_SEQ.nextval;
END SENSITIVE_INFO_TRG;
/

ALTER TABLE ADAPTER.SENSITIVE_INFO ADD (
  CONSTRAINT SENSITIVE_INFO_PK
  PRIMARY KEY
  (INFO_ID)
  USING INDEX ADAPTER.SENSITIVE_INFO_PK
  ENABLE VALIDATE);

--- **************   End SENSITIVE_INFO ****************************

--- **************   Start NOTES_LIST  *************************

CREATE SEQUENCE ADAPTER.NOTES_LIST_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.NOTES_LIST
(
	NOTE_ID NUMBER NOT NULL ENABLE, 
	LOCATION VARCHAR2(255 BYTE) NOT NULL,
	SUB_LOCATION VARCHAR2(255 BYTE)
)  TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.NOTES_LIST_PK ON ADAPTER.NOTES_LIST
(NOTE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.NOTES_LIST_TRG
BEFORE INSERT
ON ADAPTER.NOTES_LIST
FOR EACH ROW
BEGIN
    :new.NOTE_ID := ADAPTER.NOTES_LIST_SEQ.nextval;
END NOTES_LIST_TRG;
/

ALTER TABLE ADAPTER.NOTES_LIST ADD (
  CONSTRAINT NOTES_LIST_PK
  PRIMARY KEY
  (NOTE_ID)
  USING INDEX ADAPTER.NOTES_LIST_PK
  ENABLE VALIDATE);
--- **************   End NOTES_LIST  *************************
--- **************   Insert  Sensitive on/off flag  **********
INSERT INTO ADAPTER.PROPERTIES VALUES('FILTER_SENSITIVE', '0');
  

CREATE OR REPLACE SYNONYM ADAPTER_APP.SENSITIVE_INFO FOR ADAPTER.SENSITIVE_INFO;
CREATE OR REPLACE SYNONYM ADAPTER_APP.NOTES_LIST FOR ADAPTER.NOTES_LIST;

--- **** Update permissions.
GRANT SELECT ON ADAPTER.SENSITIVE_INFO TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.SENSITIVE_INFO TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.NOTES_LIST TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.NOTES_LIST TO ADAPTER_READ;

spool off