--- **************   Start SAB Create  *************************

CREATE SEQUENCE ADAPTER.SAB_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.SAB
(
	SAB_ID NUMBER NOT NULL ENABLE, 
	TRANSLATION_ID NUMBER NOT NULL ENABLE, 
	SAB_TEXT VARCHAR2(255 BYTE),
	FOREIGN KEY (TRANSLATION_ID) REFERENCES ADAPTER.TRANSLATIONS(TRANSLATION_ID) ON DELETE CASCADE
)  TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.SAB_PK ON ADAPTER.SAB
(SAB_ID);

CREATE OR REPLACE TRIGGER ADAPTER.SAB_TRG
BEFORE INSERT
ON ADAPTER.SAB
FOR EACH ROW
BEGIN
    :new.SAB_ID := ADAPTER.SAB_SEQ.nextval;
END SAB_TRG;
/

ALTER TABLE ADAPTER.SAB ADD (
  CONSTRAINT SAB_PK
  PRIMARY KEY
  (SAB_ID)
  USING INDEX ADAPTER.SAB_PK
  ENABLE VALIDATE);
--- **************   End SAB Create  *************************

--- **************   Create Allergies View to include SAB *******

CREATE OR REPLACE FORCE VIEW ADAPTER.TRANSLATIONS_VIEW 
AS 
SELECT SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME, SAB_TEXT FROM 
	(ADAPTER.TRANSLATIONS T LEFT OUTER JOIN ADAPTER.SAB S ON S.TRANSLATION_ID = T.TRANSLATION_ID);

--- **************   End Allergies View.  ***********************

CREATE OR REPLACE SYNONYM ADAPTER_APP.TRANSLATIONS_VIEW FOR ADAPTER.TRANSLATIONS_VIEW;
GRANT SELECT ON ADAPTER.TRANSLATIONS_VIEW TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.TRANSLATIONS_VIEW TO ADAPTER_READ;
CREATE OR REPLACE SYNONYM ADAPTER_APP.SAB FOR ADAPTER.SAB;
GRANT SELECT ON ADAPTER.SAB TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.SAB TO ADAPTER_READ;