--- *** This script will add the Request Log table and disable it in the properties table.
--- *** Since 6.0.2

--- **************   Start Advanced Request/Response Logging *******************
DROP TABLE ADAPTER.REQUEST_LOG CASCADE  CONSTRAINT PURGE;
DROP SEQUENCE ADAPTER.REQUEST_LOG_SEQ;

CREATE SEQUENCE ADAPTER.REQUEST_LOG_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.REQUEST_LOG
(
	ID NUMBER NOT NULL,
	HCID VARCHAR2(255 BYTE), 
	PID VARCHAR2(255 BYTE),
	START_TIME TIMESTAMP, 
	STOP_TIME TIMESTAMP, 
	UUID VARCHAR2(100 BYTE),
	ACTION VARCHAR2(255 BYTE),
	STATUS VARCHAR2(255 BYTE)
);

CREATE UNIQUE INDEX ADAPTER.REQUEST_LOG_PK ON ADAPTER.REQUEST_LOG
(ID);

CREATE OR REPLACE TRIGGER ADAPTER.REQUEST_LOG_TRG
BEFORE INSERT
ON ADAPTER.REQUEST_LOG
FOR EACH ROW
BEGIN
    :new.ID := ADAPTER.REQUEST_LOG_SEQ.nextval;
END REQUEST_LOG_TRG;
/

ALTER TABLE ADAPTER.REQUEST_LOG ADD (
  CONSTRAINT REQUEST_LOG_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADAPTER.REQUEST_LOG_PK
  ENABLE VALIDATE);

CREATE OR REPLACE PUBLIC synonym REQUEST_LOG FOR ADAPTER.REQUEST_LOG;

--- **** Update permissions.
GRANT INSERT, UPDATE, SELECT, DELETE ON ADAPTER.REQUEST_LOG TO ADAPTER_USER;

--- **** Add property to disable Advanced Outbound QD logging.
INSERT INTO ADAPTER.PROPERTIES (PROPERTY_KEY, PROPERTY_VALUE) VALUES ('REQUEST_AUDIT_ENABLED','false');
COMMIT;
--- **************   Stop Advanced Request/Response Logging *******************