--- Load up table with default values for all current partners.
SET SERVEROUTPUT ON;
DECLARE
  CURSOR c_facility IS
    SELECT DISTINCT(HOME_COMMUNITY_ID) FROM ADAPTER.FACILITIES;
    
   loinc_array dbms_sql.varchar2_table;
   v_hcid ADAPTER.FACILITIES.HOME_COMMUNITY_ID%TYPE;
BEGIN
  OPEN c_facility;
  
  --- FOR HITSP 2.5 Types LOINC is the QueryName
  --- FOR C-CDA R1.1 LOINC-C is the QueryName
   loinc_array(1) := '34133-9';
   loinc_array(2) := '18842-5';
   loinc_array(3) := '11488-4';
   loinc_array(4) := '34117-2';
   loinc_array(5) := '28570-0';
   loinc_array(6) := '29752-3';
   loinc_array(7) := '18726-0';
   loinc_array(8) := '27898-6';
   
   LOOP
    FETCH c_facility INTO v_hcid;
    EXIT WHEN c_facility%NOTFOUND;
    FOR i IN 1 .. loinc_array.LAST
      LOOP
        DBMS_OUTPUT.PUT_LINE('Should add ' || v_hcid || ' with ' || loinc_array(i));
        INSERT INTO ADAPTER.FAC_SUP_DOCTYPES 
            (HOME_COMMUNITY_ID,LOIN_CD,DOC_SPEC_TYPE,IS_PREF_TYPE,QUERYNAME)
          VALUES
            (v_hcid, loinc_array(i), 'HITSP 2.5', 'Y', loinc_array(i));
    END LOOP;
   END LOOP;
END;
/
COMMIT;
--- Remove HITSP as the preferred type for health summaries.
UPDATE ADAPTER.FAC_SUP_DOCTYPES SET IS_PREF_TYPE = 'N' WHERE HOME_COMMUNITY_ID = '2.16.840.1.113883.4.349' AND LOIN_CD = '34133-9';
COMMIT;

--- Setup C-CDA as preferred type for VA health summaries.
INSERT INTO ADAPTER.FAC_SUP_DOCTYPES 
    (HOME_COMMUNITY_ID,LOIN_CD,DOC_SPEC_TYPE,IS_PREF_TYPE,QUERYNAME)
  VALUES
    ('2.16.840.1.113883.4.349','34133-9' , 'C-CDA R1.1', 'Y', '34133-9-C');
COMMIT;


