--- Load up table with default values for all current partners.
--- Since 6.1.0
spool Insert_Fac_Supported_Types.log

SET SERVEROUTPUT ON;
DECLARE
  CURSOR c_facility IS
    SELECT FACILITY_ID, HOME_COMMUNITY_ID FROM ADAPTER.FACILITIES;
   
  CURSOR c_va_types IS	
	SELECT VA_TYPE_ID, QUERYNAME FROM ADAPTER.VA_TYPES;

  CURSOR c_f_va_id IS
	SELECT FACILITY_ID FROM ADAPTER.FACILITIES WHERE FACILITY_NUMBER = 'VA';
	
   v_f_id ADAPTER.FACILITIES.FACILITY_ID%TYPE;
   va_f_id ADAPTER.FACILITIES.FACILITY_ID%TYPE;
   v_hcid ADAPTER.FACILITIES.HOME_COMMUNITY_ID%TYPE;
   v_va_id ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
   v_va_q_name ADAPTER.VA_TYPES.QUERYNAME%TYPE;
   
BEGIN
  OPEN c_facility;
  	OPEN c_f_va_id;
	FETCH c_f_va_id INTO va_f_id;
	
   LOOP
    FETCH c_facility INTO v_f_id, v_hcid;
    EXIT WHEN c_facility%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE('Starting  ' || v_f_id);
	IF v_f_id != va_f_id THEN
		OPEN c_va_types;
		LOOP
			FETCH c_va_types INTO v_va_id, v_va_q_name;
			EXIT WHEN c_va_types%NOTFOUND;
			IF v_va_q_name != '34133-9-C' THEN
				INSERT INTO ADAPTER.FACILITY_SUPPORTED_TYPES 
					(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
				VALUES
					(v_f_id, v_va_id, 'Y');
			END IF;
		END LOOP;
		CLOSE c_va_types;
	END IF;
   END LOOP;
   CLOSE c_facility;
   
	OPEN c_va_types;
	LOOP
		FETCH c_va_types INTO v_va_id, v_va_q_name;
		EXIT WHEN c_va_types%NOTFOUND;
		IF v_va_q_name != '34133-9' THEN
			INSERT INTO ADAPTER.FACILITY_SUPPORTED_TYPES 
				(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
			VALUES
				(va_f_id, v_va_id, 'Y');
		ELSE
			INSERT INTO ADAPTER.FACILITY_SUPPORTED_TYPES 
				(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
			VALUES
				(va_f_id, v_va_id, 'N');		
		END IF;
	END LOOP;
END;
/
COMMIT;

spool off;