-- ===============================================================================================================================
spool Facilities_Operations.log

CREATE TABLE ADAPTER.FACILITIES_OPERATIONS(
FACILITY_ID  NUMBER PRIMARY KEY,
IN_ALLOW_PATIENT_DICOVERY VARCHAR2(1),
IN_ALLOW_DOC_QUERY VARCHAR2(1),
IN_ALLOW_DOC_RETRIEVE VARCHAR2(1),
OUT_ALLOW_PATIENT_DICOVERY VARCHAR2(1),
OUT_ALLOW_DOC_QUERY VARCHAR2(1),
OUT_ALLOW_DOC_RETRIEVE VARCHAR2(1),
ON_OFF_BOARD VARCHAR2(1),
CONSTRAINT FK_FACILITIES_OPERATIONS FOREIGN KEY (FACILITY_ID) REFERENCES ADAPTER.FACILITIES(FACILITY_ID)) TABLESPACE ADAPTER_DATA01;

---Create CONSTRAINTS

alter table ADAPTER.FACILITIES_OPERATIONS add constraint IN_CHECK_PATIENT_DICOVERY CHECK (IN_ALLOW_PATIENT_DICOVERY IN ('Y','N'));
alter table ADAPTER.FACILITIES_OPERATIONS add constraint IN_CHECK_DOC_QUERY CHECK (IN_ALLOW_DOC_QUERY IN ('Y','N') );
alter table ADAPTER.FACILITIES_OPERATIONS add constraint IN_CHECK_DOC_RETRIEVE CHECK (IN_ALLOW_DOC_RETRIEVE IN ('Y','N'));  


alter table ADAPTER.FACILITIES_OPERATIONS add constraint OUT_CHECK_PATIENT_DICOVERY CHECK (OUT_ALLOW_PATIENT_DICOVERY IN ('Y','N'));
alter table ADAPTER.FACILITIES_OPERATIONS add constraint OUT_CHECK_DOC_QUERY CHECK (OUT_ALLOW_DOC_QUERY IN ('Y','N') );
alter table ADAPTER.FACILITIES_OPERATIONS add constraint OUT_CHECK_DOC_RETRIEVE CHECK (OUT_ALLOW_DOC_RETRIEVE IN ('Y','N'));  

alter table ADAPTER.FACILITIES_OPERATIONS add constraint BI_ON_OFF_BOARD CHECK (ON_OFF_BOARD IN ('Y','N'));  

CREATE OR REPLACE SYNONYM ADAPTER_APP.FACILITIES_OPERATIONS FOR ADAPTER.FACILITIES_OPERATIONS;          
GRANT INSERT, SELECT, UPDATE, DELETE ON ADAPTER.FACILITIES_OPERATIONS TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.FACILITIES_OPERATIONS TO ADAPTER_READ;

spool off