CREATE TABLE ADAPTER.FACILITIES
(
  FACILITY_ID             NUMBER,
  FACILITY_NUMBER         VARCHAR2(10 BYTE) CONSTRAINT FACILITIES_NN1 NOT NULL,
  HOME_COMMUNITY_ID       VARCHAR2(255 BYTE) CONSTRAINT FACILITIES_NN2 NOT NULL,
  FACILITY_NAME           VARCHAR2(255 BYTE) CONSTRAINT FACILITIES_NN3 NOT NULL,
  FULL_HOME_COMMUNITY_ID  VARCHAR2(255 BYTE),
  USE_SPEC_VERSION		  VARCHAR2(5) DEFAULT '2.0',
  ACP_CHECK CHAR(1)
);


CREATE UNIQUE INDEX ADAPTER.FACILITIES_PK ON ADAPTER.FACILITIES
(FACILITY_ID);


CREATE OR REPLACE TRIGGER ADAPTER.FACILITY_ID_TRG
BEFORE INSERT
ON ADAPTER.FACILITIES 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.FACILITY_ID is null then
        select FACILITY_ID_SEQ.NEXTVAL into N from DUAL;
        :new.FACILITY_ID := N;
    end if;
end FACILITY_ID_TRG;
/


ALTER TABLE ADAPTER.FACILITIES ADD (
  CONSTRAINT FACILITIES_PK
  PRIMARY KEY
  (FACILITY_ID)
  USING INDEX FACILITIES_PK
  ENABLE VALIDATE);
