spool DataFiltering_INSERT.log 
--- Since 6.4.0  This script will add all test data needed to use in the DEV/SQA environments.
---  *************    Start populating Enums  **************************
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('CONTAINS_TEXT','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('NOT_CONTAINS_TEXT','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('EQUALS_TEXT','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('NOT_EQUALS_TEXT','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('DATE_GREATER','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('DATE_LESS','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('HOLD_PERIOD','');
INSERT INTO ADAPTER.INT_FILT_CONST (FILTER_NAME, FILTER_DESCRIPTION) 
	VALUES ('LIST_LIMIT','');	
COMMIT;
---  *************    Stop populating Enums  **************************

---  *************    Start populating Facilities  ********************
INSERT INTO ADAPTER.INT_FACILITIES (FACILITY_NUMBER, FACILITY_NAME) 
	VALUES ('MHV','My HealthE Vet');
INSERT INTO ADAPTER.INT_FACILITIES (FACILITY_NUMBER, FACILITY_NAME) 
	VALUES ('NotMHV','Not My HealthE Vet');
  
COMMIT;
---  *************    Stop populating Facilities  ********************

---  *************    Start populating Filters  **********************
---  For each facility on record this will prepopulate the filters with the defaults provided by MHV.
SET SERVEROUTPUT ON;
DECLARE
  CURSOR c_facility IS
    SELECT FACILITY_ID FROM ADAPTER.INT_FACILITIES;
   
  CURSOR c_enums IS	
	SELECT FILTER_ID, FILTER_NAME FROM ADAPTER.INT_FILT_CONST;
	
   v_f_id ADAPTER.INT_FACILITIES.FACILITY_ID%TYPE;
   v_filter_id ADAPTER.INT_FILT_CONST.FILTER_ID%TYPE;
   v_filter_name ADAPTER.INT_FILT_CONST.FILTER_NAME%TYPE;
   
BEGIN
	OPEN c_facility;
  
--Each facility loop
   LOOP
    FETCH c_facility INTO v_f_id;
    EXIT WHEN c_facility%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE('Starting  ' || v_f_id);
	OPEN c_enums;
		LOOP
			--- Each enumeration value.
			FETCH c_enums INTO v_filter_id, v_filter_name;
			EXIT WHEN c_enums%NOTFOUND;
			--- Start looking at each type and add the correct default params.
			CASE WHEN v_filter_name = 'NOT_CONTAINS_TEXT' THEN
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'progressNotes', 'nationalTitleService', 'COMPENSATION '||chr(38)||' PENSION');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'consultnotes', 'nationalTitleService', 'COMPENSATION '||chr(38)||' PENSION');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'encounterDocs', 'nationalTitleService', 'COMPENSATION '||chr(38)||' PENSION');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'progressNotes', 'nationalTitleService', 'COMPENSATION '||chr(38)||'amp; PENSION');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'consultnotes', 'nationalTitleService', 'COMPENSATION '||chr(38)||'amp; PENSION');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'encounterDocs', 'nationalTitleService', 'COMPENSATION '||chr(38)||'amp; PENSION');					          
				COMMIT;
			WHEN v_filter_name = 'DATE_GREATER' THEN
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'progressNotes', 'signingClinician.dateTime', '03130101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'consultnotes', 'signingClinician.dateTime', '03130101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'historyphysicalnotes', 'signingClinician.dateTime', '03130101');					
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'dischargeSummaries', 'signingClinician.dateTime', '03130101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'clinicalProcedureNotes', 'signingClinician.dateTime', '02000101');					
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'labs', 'resulted', '02000101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'radiologies', 'signingClinician.dateTime', '02000101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'pathologies', 'signingClinician.dateTime', '02000101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'encounterDocs', 'signingClinician.dateTime', '03130101');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'procedureDocs', 'signingClinician.dateTime', '03130101');					
				COMMIT;
			WHEN v_filter_name = 'HOLD_PERIOD' THEN
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'problems', 'entered', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'results', 'resulted', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'radiologies', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'pathologies', 'signingClinician.dateTime', '14');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'progressNotes', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'consultnotes', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'dischargeSummaries', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'historyphysicalnotes', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'labs', 'resulted', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'radiologies', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'pathologies', 'signingClinician.dateTime', '14');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'clinicalProcedureNotes', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'encounterDocs', 'signingClinician.dateTime', '3');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'procedureDocs', 'signingClinician.dateTime', '3');					
			WHEN v_filter_name = 'LIST_LIMIT' THEN
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'clinicalProcedureNotes', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'surgicalProcedureNotes', '', '0');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'labs', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'radiologies', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'pathologies', '', '20');	
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'consultnotes', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'historyphysicalnotes', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'dischargeSummaries', '', '20');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'visits', 'documents', '10');					
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'visits', '', '25');
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'surgeries', 'documents', '10');					
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'surgeries', '', '25');	
				COMMIT;
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'encounterDocs', '', '10');	
				COMMIT;
				INSERT INTO ADAPTER.INT_FAC_FILT 
					(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
				VALUES
					(v_f_id, v_filter_id, 'procedureDocs', '', '10');	
				COMMIT;        
			ELSE
			CONTINUE;
			END CASE;
		END LOOP;
		CLOSE c_enums;
   END LOOP;
   CLOSE c_facility;
END;
/
COMMIT;

---  *************    Stop populating Filters  ***********************

spool off