--- Creation for all tables required in the DataFiltering requirement.
--- Since Adapter 6.4.0
--- This script will only add the tables it will not create any test data.
--- There are three tables and 1 view created in this script: INT_FAC_FILT, INT_FILT_CONST, INT_FACILITIES, and INT_FAC_FILT_VIEW.

--- **************   Start INT_FACILITIES *******************

spool DataFiltering.log

CREATE SEQUENCE ADAPTER.INT_FAC_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.INT_FACILITIES
(
	FACILITY_ID NUMBER NOT NULL,
	FACILITY_NUMBER VARCHAR2(255 BYTE), 
	FACILITY_NAME VARCHAR2(255 BYTE)
) TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.INT_FAC_PK ON ADAPTER.INT_FACILITIES
(FACILITY_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FAC_TRG
BEFORE INSERT
ON ADAPTER.INT_FACILITIES
FOR EACH ROW
BEGIN
    :new.FACILITY_ID := ADAPTER.INT_FAC_SEQ.nextval;
END INT_FAC_TRG;
/

ALTER TABLE ADAPTER.INT_FACILITIES ADD (
  CONSTRAINT INT_FAC_PK
  PRIMARY KEY
  (FACILITY_ID)
  USING INDEX ADAPTER.INT_FAC_PK
  ENABLE VALIDATE);

--- **************   End INT_FACILITIES ****************************

--- **************   Start INT_FILT_CONST  *************************

CREATE SEQUENCE ADAPTER.INT_FILT_CONST_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.INT_FILT_CONST
(
	FILTER_ID NUMBER NOT NULL ENABLE, 
	FILTER_NAME VARCHAR2(255 BYTE) NOT NULL,
	FILTER_DESCRIPTION VARCHAR2(255 BYTE)
)  TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.INT_FILT_CONST_PK ON ADAPTER.INT_FILT_CONST
(FILTER_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FILT_CONST_TRG
BEFORE INSERT
ON ADAPTER.INT_FILT_CONST
FOR EACH ROW
BEGIN
    :new.FILTER_ID := ADAPTER.INT_FILT_CONST_SEQ.nextval;
END INT_FILT_CONST_TRG;
/

ALTER TABLE ADAPTER.INT_FILT_CONST ADD (
  CONSTRAINT INT_FILT_CONST_PK
  PRIMARY KEY
  (FILTER_ID)
  USING INDEX ADAPTER.INT_FILT_CONST_PK
  ENABLE VALIDATE);
--- **************   End INT_FILT_CONST  *************************

--- **************   Start INT_FAC_FILT  *************************

CREATE SEQUENCE ADAPTER.INT_FAC_FILT_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE TABLE ADAPTER.INT_FAC_FILT
(
	FAC_FILT_ID NUMBER NOT NULL ENABLE, 
	FACILITY_ID NUMBER NOT NULL ENABLE, 
	FILTER_ID NUMBER NOT NULL ENABLE, 
	ROOT_NAME VARCHAR2(255 BYTE) NOT NULL,
	OBJ_NAME VARCHAR2(255 BYTE),
	PARAM VARCHAR2(255 BYTE) NOT NULL,
	FOREIGN KEY (FACILITY_ID) REFERENCES ADAPTER.INT_FACILITIES(FACILITY_ID) ON DELETE CASCADE,
	FOREIGN KEY (FILTER_ID) REFERENCES ADAPTER.INT_FILT_CONST(FILTER_ID) ON DELETE CASCADE
)  TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.INT_FAC_FILT_PK ON ADAPTER.INT_FAC_FILT
(FAC_FILT_ID);

CREATE OR REPLACE TRIGGER ADAPTER.INT_FAC_FILT_TRG
BEFORE INSERT
ON ADAPTER.INT_FAC_FILT
FOR EACH ROW
BEGIN
    :new.FAC_FILT_ID := ADAPTER.INT_FAC_FILT_SEQ.nextval;
END INT_FAC_FILT_TRG;
/

ALTER TABLE ADAPTER.INT_FAC_FILT ADD (
  CONSTRAINT INT_FAC_FILT_PK
  PRIMARY KEY
  (FAC_FILT_ID)
  USING INDEX ADAPTER.INT_FAC_FILT_PK
  ENABLE VALIDATE);
--- **************   End INT_FAC_FILT  *************************	
	
--- **************   Start INT_FAC_FILT_VIEW *******************

CREATE OR REPLACE FORCE VIEW ADAPTER.INT_FAC_FILT_VIEW
AS
SELECT FAC_FILT_ID, FACILITY_NAME, FACILITY_NUMBER, FILTER_NAME, ROOT_NAME, OBJ_NAME, PARAM FROM
	((ADAPTER.INT_FAC_FILT S INNER JOIN ADAPTER.INT_FACILITIES F ON S.FACILITY_ID = F.FACILITY_ID) INNER JOIN ADAPTER.INT_FILT_CONST V ON S.FILTER_ID = V.FILTER_ID);

--- **************   End INT_FAC_FILT_VIEW   *******************

CREATE OR REPLACE SYNONYM ADAPTER_APP.INT_FAC_FILT FOR ADAPTER.INT_FAC_FILT;
CREATE OR REPLACE SYNONYM ADAPTER_APP.INT_FACILITIES FOR ADAPTER.INT_FACILITIES;
CREATE OR REPLACE SYNONYM ADAPTER_APP.INT_FILT_CONST FOR ADAPTER.INT_FILT_CONST;
CREATE OR REPLACE SYNONYM ADAPTER_APP.INT_FAC_FILT_VIEW FOR ADAPTER.INT_FAC_FILT_VIEW;

--- **** Update permissions.
GRANT SELECT ON ADAPTER.INT_FAC_FILT TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.INT_FAC_FILT TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.INT_FACILITIES TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.INT_FACILITIES TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.INT_FILT_CONST TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.INT_FILT_CONST TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.INT_FAC_FILT_VIEW TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.INT_FAC_FILT_VIEW TO ADAPTER_READ;

spool off