CREATE TABLE DOCUMENTS
(
  DOCUMENT_ID                   NUMBER CONSTRAINT DOCUMENTS_NN1 NOT NULL,
  BEGIN_DATE                    TIMESTAMP(6),
  CLASS_CODE                    VARCHAR2(255 BYTE),
  CLASS_CODE_DISPLAY_NAME       VARCHAR2(255 BYTE),
  CLASS_CODE_SCHEME             VARCHAR2(255 BYTE),
  CREATION_TIME                 TIMESTAMP(6),
  DOCUMENT_UNIQUE_ID            VARCHAR2(255 BYTE),
  END_DATE                      TIMESTAMP(6),
  RAW_DATA_HASH                 VARCHAR2(255 BYTE),
  MIME_TYPE                     VARCHAR2(255 BYTE),
  PATIENT_ID                    VARCHAR2(255 BYTE),
  RAW_DATA                      BLOB,
  RAW_DATA_SIZE                 NUMBER,
  TITLE                         VARCHAR2(255 BYTE),
  LAST_ACCESSED_TIME            TIMESTAMP(6),
  DOC_GEN_QUERY_NAME            VARCHAR2(255 BYTE),
  DOC_GEN_QUERY_PARAMS          VARCHAR2(2048 BYTE),
  FORMAT_CODE                   VARCHAR2(255 BYTE),
  AVAILABILITY_STATUS           VARCHAR2(255 BYTE),
  FORMAT_CODE_SCHEME            VARCHAR2(255 BYTE),
  FORMAT_CODE_DISPLAY_NAME      VARCHAR2(255 BYTE),
  SOURCE_PATIENT_ID             VARCHAR2(255 BYTE),
  TYPE_CODE                     VARCHAR2(255 BYTE),
  TYPE_CODE_SCHEME              VARCHAR2(255 BYTE),
  TYPE_CODE_DISPLAY_NAME        VARCHAR2(255 BYTE),
  PATIENT_LAST_NAME             VARCHAR2(255 BYTE),
  PATIENT_GIVEN_NAME            VARCHAR2(255 BYTE),
  PATIENT_SSN                   VARCHAR2(9 BYTE),
  PATIENT_PREF_FACILITY_NUMBER  VARCHAR2(20 BYTE),
  PATIENT_PREF_FACILITY_NAME    VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX DOCUMENTS_PK ON DOCUMENTS
(DOCUMENT_ID);


CREATE OR REPLACE TRIGGER DOCUMENT_ID_TR
BEFORE INSERT
ON DOCUMENTS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
    N NUMBER;
begin
    if :NEW.DOCUMENT_ID IS NULL then
        select DOCUMENT_ID_SEQ.NEXTVAL into N from DUAL;
        :NEW.DOCUMENT_ID := N;
    end if;
end DOCUMENT_ID_TR;
/


ALTER TABLE DOCUMENTS ADD (
  CONSTRAINT DOCUMENTS_PK
  PRIMARY KEY
  (DOCUMENT_ID)
  USING INDEX DOCUMENTS_PK
  ENABLE VALIDATE);
