CREATE TABLE CACHE
(
  CACHE_ID  NUMBER,
  HASH      VARCHAR2(255 BYTE) CONSTRAINT CACHE_NN1 NOT NULL,
  DATA      BLOB
);


CREATE UNIQUE INDEX CACHE_PK ON CACHE
(CACHE_ID);


CREATE UNIQUE INDEX CACHE_UK1 ON CACHE
(HASH);


CREATE OR REPLACE TRIGGER CACHE_ID_TRG
BEFORE INSERT
ON CACHE 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.CACHE_ID is null then
        select CACHE_ID_SEQ.NEXTVAL into N from DUAL;
        :new.CACHE_ID := N;
    end if;
end CACHE_ID_TRG;
/


ALTER TABLE CACHE ADD (
  CONSTRAINT CACHE_PK
  PRIMARY KEY
  (CACHE_ID)
  USING INDEX CACHE_PK
  ENABLE VALIDATE,
  CONSTRAINT CACHE_UK1
  UNIQUE (HASH)
  USING INDEX CACHE_UK1
  ENABLE VALIDATE);
