--- Updated to add additional MVI traits and DOC_SPEC_TYPE.
spool Audits_Report_View.log

CREATE OR REPLACE FORCE VIEW ADAPTER.AUDITS_REPORT
(
   AUDIT_ID,
   ACTION_NAME,
   USER_ID,
   ORGANIZATION_ID,
   PATIENT_ID,
   PURPOSE_FOR_USE,
   DOCUMENT_ID,
   AUDIT_TIME,
   OPTOUT_REASON_ID,
   REMOTE_ORGANIZATION_ID,
   REMOTE_DOC_REPOSITORY_ID,
   REMOTE_DOC_ID,
   DETAILS,
   PATIENT_LAST_NAME,
   PATIENT_MIDDLE_NAME,
   PATIENT_GIVEN_NAME,
   MOTHER_MAIDEN_NAME,
   POB_CITY,
   POB_STATE,
   USER_NAME,
   PATIENT_FACILITY_NUMBER,
   PATIENT_SSN,
   PATIENT_FACILITY_NAME,
   USER_FACILITY_NUMBER,
   USER_FACILITY_NAME,
   ORGANIZATION_NAME,
   REMOTE_ORGANIZATION_NAME,
   OPTOUT_REASON_TEXT,
   DOCUMENT_TITLE,
   DOCUMENT_SOURCE_PATIENT_ID,
   USER_ROLE,
   DOC_SPEC_TYPE
)
AS
   SELECT a.AUDIT_ID,
          a.ACTION_NAME,
          UPPER (a.USER_ID),
          a.ORGANIZATION_ID,
          UPPER (a.PATIENT_ID),
          a.PURPOSE_FOR_USE,
          a.DOCUMENT_ID,
          a.AUDIT_TIME,
          a.OPTOUT_REASON_ID,
          a.REMOTE_ORGANIZATION_ID,
          a.REMOTE_DOC_REPOSITORY_ID,
          a.REMOTE_DOC_ID,
          UPPER (a.DETAILS),
          UPPER (a.PATIENT_LAST_NAME),
		  UPPER (a.PATIENT_MIDDLE_NAME),
          UPPER (a.PATIENT_GIVEN_NAME),
		  UPPER (a.MOTHER_MAIDEN_NAME),
		  UPPER (a.POB_CITY),
		  UPPER (a.POB_STATE),
		  UPPER (a.USER_NAME),
          a.PATIENT_FACILITY_NUMBER,
          a.PATIENT_SSN,
          UPPER (a.PATIENT_FACILITY_NAME),
          a.USER_FACILITY_NUMBER,
          UPPER (a.USER_FACILITY_NAME),
          UPPER (f1.FACILITY_NAME) ORGANIZATION_NAME,
          UPPER (f2.FACILITY_NAME) REMOTE_ORGANIZATION_NAME,
          opt.TEXT OPTOUT_REASON_TEXT,
          UPPER (d.TITLE) DOCUMENT_TITLE,
          d.SOURCE_PATIENT_ID DOCUMENT_SOURCE_PATIENT_ID,
          a.USER_ROLE,
		  a.DOC_SPEC_TYPE

     FROM AUDITS a
          LEFT OUTER JOIN FACILITIES f1
             ON a.ORGANIZATION_ID = f1.FULL_HOME_COMMUNITY_ID
          LEFT OUTER JOIN FACILITIES f2
             ON a.REMOTE_ORGANIZATION_ID = f2.FULL_HOME_COMMUNITY_ID
          LEFT OUTER JOIN OPTOUT_REASONS opt
             ON a.OPTOUT_REASON_ID = opt.OPTOUT_REASON_ID
          LEFT OUTER JOIN DOCUMENTS d
             ON a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID;

CREATE OR REPLACE SYNONYM ADAPTER_APP.AUDITS_REPORT FOR ADAPTER.AUDITS_REPORT;
GRANT SELECT ON ADAPTER.AUDITS_REPORT TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.AUDITS_REPORT TO ADAPTER_READ;

spool off