CREATE TABLE AUDITS
(
  AUDIT_ID                  NUMBER CONSTRAINT AUDITS_NN1 NOT NULL,
  ACTION_NAME               VARCHAR2(255 BYTE) CONSTRAINT AUDITS_NN2 NOT NULL,
  USER_ID                   VARCHAR2(255 BYTE),
  ORGANIZATION_ID           VARCHAR2(255 BYTE),
  PATIENT_ID                VARCHAR2(255 BYTE),
  PURPOSE_FOR_USE           VARCHAR2(255 BYTE),
  DOCUMENT_ID               VARCHAR2(255 BYTE),
  AUDIT_TIME                TIMESTAMP(6) CONSTRAINT AUDITS_NN3 NOT NULL,
  OPTOUT_REASON_ID          NUMBER,
  REMOTE_ORGANIZATION_ID    VARCHAR2(255 BYTE),
  REMOTE_DOC_REPOSITORY_ID  VARCHAR2(255 BYTE),
  REMOTE_DOC_ID             VARCHAR2(255 BYTE),
  DETAILS                   VARCHAR2(4000 BYTE),
  PATIENT_LAST_NAME         VARCHAR2(255 BYTE),
  PATIENT_GIVEN_NAME        VARCHAR2(255 BYTE),
  USER_NAME                 VARCHAR2(255 BYTE),
  PATIENT_FACILITY_NUMBER   VARCHAR2(20 BYTE),
  PATIENT_SSN               VARCHAR2(20 BYTE),
  PATIENT_FACILITY_NAME     VARCHAR2(255 BYTE),
  USER_FACILITY_NUMBER      VARCHAR2(255 BYTE),
  USER_FACILITY_NAME        VARCHAR2(255 BYTE),
  USER_ROLE                 VARCHAR2(255 BYTE),
  POB_CITY 					VARCHAR2(50),
  POB_STATE 				VARCHAR2(50),
  PATIENT_MIDDLE_NAME 		VARCHAR2(255),
  MOTHER_MAIDEN_NAME		VARCHAR2(255),
  DOC_SPEC_TYPE 			VARCHAR2(50 BYTE)
);


CREATE UNIQUE INDEX AUDITS_PK ON AUDITS
(AUDIT_ID);


CREATE OR REPLACE TRIGGER AUDIT_ID_TRG
BEFORE INSERT
ON AUDITS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
  if :NEW.AUDIT_ID is null then
      select AUDIT_ID_SEQ.NEXTVAL into N from DUAL;
      :new.AUDIT_ID := N;
  end if;
end AUDIT_ID_TRG;
/


ALTER TABLE AUDITS ADD (
  CONSTRAINT AUDITS_PK
  PRIMARY KEY
  (AUDIT_ID)
  USING INDEX AUDITS_PK
  ENABLE VALIDATE);
