package gov.va.med.nhin.adapter.datamanager.internalApp;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import gov.va.med.nhin.adapter.datamanager.DataDate;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.junit.Test;

public class InternalAppFilterTest {
	@Test
	public final void testFilterObjects() {
		SmartHashMap all = generateData();
		// TODO: Complete this.
	}

	@SuppressWarnings("rawtypes")
	@Test
	public final void testFilterSectionObjects() {
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		String date = generateFileManDate(new Date(), Calendar.MONTH, -2);
		filterObj.setFilterValue("4");
		filterObj.setOperation(InternalAppOperations.LIST_LIMIT);
		//filterObj.setSubRoot("documents");
		filterObj.setObjectName("documents");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		for(SmartHashMap value : list){
			assertTrue("No documents were found.  Expected Docs.", value.containsKey("documents"));
			assertEquals("List Size should be 4", 4, ((List) value.get("documents")).size());
		}
	}

	@Test
	public final void testFilterMapObjects() {
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		String date = generateFileManDate(new Date(), Calendar.MONTH, -2);
		filterObj.setFilterValue(date);
		filterObj.setOperation(InternalAppOperations.DATE_GREATER);
		filterObj.setObjectName("entered");
		filter.filterMapObjects(filterObj, list);
		
		assertEquals("List Size should be 4", 4, list.size());
	}
	
	@Test
	public final void testSectionLimit(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		filterObj.setFilterValue("4");
		filterObj.setOperation(InternalAppOperations.LIST_LIMIT);
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		assertTrue("No values were found.  Expected Section List.", CollectionUtils.isNotEmpty(list));
		assertEquals("List Size should be 4", 4, list.size());
	}
	
	@SuppressWarnings("rawtypes")
	@Test
	public final void testSubItemLimit(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		filterObj.setFilterValue("4");
		filterObj.setOperation(InternalAppOperations.LIST_LIMIT);
		filterObj.setObjectName("documents");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		assertEquals("Should not have removed main list items.", 10, list.size() );
		
		for(SmartHashMap value : list){
			assertTrue("No documents were found.  Expected Docs.", value.containsKey("documents"));
			assertEquals("List Size should be 4", 4, ((List) value.get("documents")).size());
		}	
	}
	
	@SuppressWarnings("rawtypes")
	@Test
	public final void testLimitRemoveAllSub(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		filterObj.setFilterValue("0");
		filterObj.setOperation(InternalAppOperations.LIST_LIMIT);
		filterObj.setObjectName("documents");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		assertEquals("Should not have removed main list items.", 10, list.size() );
		
		for(SmartHashMap value : list){
			//assertTrue("Documents were found.  Expected No Docs.", !value.containsKey("documents"));
			if(value.containsKey("documents")){
				assertEquals("Should have removed sub list items.", 0, ((List) value.get("documents")).size() );
			}
		}	
	}	
	
	@Test
	public final void testHoldPeriod(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		filterObj.setFilterValue("60");
		filterObj.setOperation(InternalAppOperations.HOLD_PERIOD);
		filterObj.setObjectName("entered");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		assertTrue("No values were found.  Expected Section List.", CollectionUtils.isNotEmpty(list));
		assertEquals("List Size should be 7", 7, list.size());
	}
	
	@SuppressWarnings("rawtypes")
	@Test
	public final void testSubRootHoldPeriod(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		String date = generateFileManDate(new Date(), Calendar.MONTH, -2);
		filterObj.setFilterValue("60");
		filterObj.setOperation(InternalAppOperations.HOLD_PERIOD);
		filterObj.setObjectName("signer.entered");
		filterObj.setSubRoot("documents");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		for(SmartHashMap value : list){
			assertTrue("No documents were found.  Expected Docs.", value.containsKey("documents"));
			assertEquals("List Size should be 37", 37 , ((List) value.get("documents")).size());
		}
	}
	
	@Test
	public final void testGreaterThan(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		String date = generateFileManDate(new Date(), Calendar.MONTH, -2);
		filterObj.setFilterValue(date);
		filterObj.setOperation(InternalAppOperations.DATE_GREATER);
		filterObj.setObjectName("entered");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		assertTrue("No values were found.  Expected Section List.", CollectionUtils.isNotEmpty(list));
		assertEquals("List Size should be 4", 4, list.size());
	}
	
	@Test
	public final void testSubRootGreaterThan(){
		InternalAppFilterObj filterObj = new InternalAppFilterObj();
		InternalAppFilter filter = new InternalAppFilter();
		List<SmartHashMap> list = generateFakeObjectsWDocs(10);
		String date = generateFileManDate(new Date(), Calendar.MONTH, -2);
		filterObj.setFilterValue(date);
		filterObj.setOperation(InternalAppOperations.DATE_GREATER);
		filterObj.setObjectName("signer.entered");
		filterObj.setSubRoot("documents");
		List<InternalAppFilterObj> filters = new ArrayList<InternalAppFilterObj>();
		filters.add(filterObj);
		filter.filterSectionObjects(filters, list);
		
		for(SmartHashMap value : list){
			assertTrue("No documents were found.  Expected Docs.", value.containsKey("documents"));
			assertEquals("List Size should be 4", 4 , ((List) value.get("documents")).size());
		}
	}
	
	private List<InternalAppFilterObj> generateFilters(){
		List<InternalAppFilterObj> ret = new ArrayList<InternalAppFilterObj>();
		
		
		
		return ret;
	}
	
	private SmartHashMap generateData(){
		SmartHashMap ret = new SmartHashMap();
		
		ret.put("problems", generateFakeObjects(40));
		ret.put("encounters", generateFakeSectionObjectWDocs(new Date(), "encSample"));
		
		return ret;
	}
	
	private SmartHashMap generateFakeSectionObject(final Date enteredDate, final String name){
		SmartHashMap ret = new SmartHashMap();
		
		ret.put("entered", convertDate(enteredDate));
		ret.put("name", name);
		
		ret.put("signer", generateFakeSectionObjectWSigner(enteredDate, "something"));
		return ret;
	}
	
	private SmartHashMap generateFakeSectionObjectWSigner(final Date enteredDate, final String name){
		SmartHashMap ret = new SmartHashMap();
		
		ret.put("entered", convertDate(enteredDate));
		ret.put("name", name);
		
		return ret;
	}
	
	private SmartHashMap generateFakeSectionObjectWDocs(final Date enteredDate, final String name){
		SmartHashMap ret = new SmartHashMap();
		
		ret.put("entered", convertDate(enteredDate));
		ret.put("name", name);
		ret.put("documents", generateFakeObjects(40));
		
		return ret;
	}	
	
	private List<SmartHashMap> generateFakeObjects(final int number){
		List<SmartHashMap> ret = new ArrayList<SmartHashMap>();
		Calendar cal = Calendar.getInstance();
		
		for(int i = 0; i < number; i++){
			cal.add(Calendar.DAY_OF_YEAR, -15);
			Date date = cal.getTime();
			ret.add(generateFakeSectionObject(date, "fakeDoc" + i));
		}
		
		return ret;
	}
	
	private List<SmartHashMap> generateFakeObjectsWDocs(final int number){
		List<SmartHashMap> ret = new ArrayList<SmartHashMap>();
		Calendar cal = Calendar.getInstance();
		
		for(int i = 0; i < number; i++){
			cal.add(Calendar.DAY_OF_YEAR, -15);
			Date date = cal.getTime();
			ret.add(generateFakeSectionObjectWDocs(date, "fakeDoc" + i));
		}
		
		return ret;
	}
	
	@SuppressWarnings("deprecation")
	private String generateFileManDate(final Date date){
		String year = String.valueOf(date.getYear() + 200);
		SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
		
		return year + sdf.format(date);
	}
	
	private String generateFileManDate(final Date date, final int field, final int modifier){
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(field, modifier);
		
		return generateFileManDate(cal.getTime());
	}
	
	private DataDate convertDate(final Date date) {
		DataDate ret = null;

		if (date != null) {
			ret = new DataDate(date.getTime(), "yyyyMMdd");
		}

		return ret;
	}	

}
