package gov.va.med.nhin.adapter.utils.transceiver;

import gov.va.med.nhin.adapter.utils.encoders.DCLLPEncoder;

/**
 *
 * @author David Vazquez
 */
public class HL7DCLLPSocketTransceiver extends SocketTransceiver
{
	public HL7DCLLPSocketTransceiver(String host, int port, int timeout)
	{
		super(host, port, timeout);
	}

	public String transceive(String message)
	{
		String ret;

		connect();

		send("HELO" + DCLLPEncoder.CRLF);
		ret = receive(DCLLPEncoder.CRLF);

		if(ret.startsWith("2"))
		{
			send(DCLLPEncoder.encode(message));
			ret = receive(DCLLPEncoder.CRLF);
			send("TURN" + DCLLPEncoder.CRLF);
			ret = DCLLPEncoder.decode(receive(DCLLPEncoder.DATA_END));
			send("200 OK" + DCLLPEncoder.CRLF);
		}

		send("QUIT" + DCLLPEncoder.CRLF);

		disconnect();

		return ret;
	}
}
