package gov.va.med.nhin.adapter.utils.encoders;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author David Vazquez
 */
public class MLLPEncoder
{
	public static final Logger logger = LoggerFactory.getLogger(MLLPEncoder.class.getName());

	static public final String VT = "\u000B";
	static public final String FSCR = "\u001C\r";

	static public String encode(String message)
	{
		return VT + message + FSCR;
	}

	static public String decode(String message)
	{
		String ret;

		if(message.startsWith(VT) && message.endsWith(FSCR))
		{
			ret = message.substring(1, message.length() - 2);
		}
		else
		{
			logger.debug("Malformed MLLP message.");
			ret = message;
		}

		return ret;
	}
}
