/* ----------------------------------------------------------------
 * File Name 	: PersonIdentityVO.java
 * Authored By	: spawaradmin
 * Created on	: Feb 02, 2009
 * 
 * This is copyrighted software of the United States Federal Government.   
 * Any use must be authorized by the
 * 
 * 	     Department of Veterans Affairs
 * 	     National Health Information Network - (NHIN)
 * 	     
 *
 * Any un-authorized use is strictly prohibited and subject to 
 * legal action.
 * 
 * Purpose	:
 * 
 * 
 * --------------------------------------------------------------------
 *                 M o d i f i c a t i o n   H i s t o r y
 * 
 * Date 	:
 * Author 	:
 * Purpose 	: 
 * 
 * 
 * -------------------------------------------------------------------- 
 */

package gov.va.med.nhin.adapter.utils.datasharing.services.person.vo;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import gov.va.med.nhin.adapter.utils.datasharing.system.SystemVO;
public class PersonIdentityVO  extends SystemVO {

    /**
     * Serial UID
     */
    private static final long serialVersionUID = 664588158530888567L;

    /** properties */
    protected Long m_pk;

    protected String m_lastName;

    protected String m_firstName;

    protected String m_middleInitial;

    protected String m_suffixName;

    protected String m_prefixName;

    protected String m_sex;

    protected String m_ssn;
    
    protected String m_placeOfBirth;
    
    protected String m_placeOfDeath;
    
    protected Date m_dob;
    
    protected Date m_dod;
    
    protected String m_address1;
    
    protected String m_address2;
    
    protected String m_address3;
    
    protected String m_city;
    
    protected String m_state;
    
    protected String m_zip;
    
    protected String m_phoneNumber;

    protected String m_vaId;

    protected String m_dodId;
    
    protected String m_maritalStatus;

    protected int m_adc;

    protected boolean m_adc_sync;

    protected Date lastModifiedDate;

    protected Date dateSynchStarted;

    protected Date dateSynchCompleted;

    protected String errorReceived;

    protected String m_pcf;

    protected String m_sites;

    private SimpleDateFormat oDateFormat = new SimpleDateFormat("MMM dd, yyyy");

    private SimpleDateFormat oDateFormat1 = new SimpleDateFormat("MMM dd,yyyy");

    private SimpleDateFormat oDateSlashFormat = new SimpleDateFormat("MM/dd/yy");

    private SimpleDateFormat oDateVAFormat = new SimpleDateFormat("yyyyMMdd");

    public static final String ADC_ACTIVE = "ACTIVE";

    public static final String ADC_INACTIVE = "INACTIVE";

    public static final String ADC_PENDING = "PENDING";

    public static final String ADC_ERROR = "ERROR";

    public static final String ADC_SYNC_IN_PROGRESS = "In Progress";

    public static final String ADC_SYNC_SYNCHRONIZED = "Synchronized";

    public static final String ADC_SYNC_NA = "Not Applicable";

    private static int MAX_ERR_LEN = 500; // depends on schema

    private static int MAX_NAME_LEN = 250; // depends on schema

    public String getLastName() {
        return m_lastName;
    }

    public void setLastName(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_lastName = s;
    }

    public String getFirstName() {
        return m_firstName;
    }

    public void setFirstName(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_firstName = s;
    }

    public String getMiddleInitial() {
        return m_middleInitial;
    }

    public void setMiddleInitial(String s) {
        m_middleInitial = s;
    }

    public String getPrefixName() {
        return m_prefixName;
    }

    public void setPrefixName(String name) {
        m_prefixName = name;
    }

    public String getSuffixName() {
        return m_suffixName;
    }

    public void setSuffixName(String name) {
        m_suffixName = name;
    }

    public String getSex() {
        return m_sex;
    }

    public void setSex(String s) {
        m_sex = s;
    }
    public String getMaritalStatus() {
        return m_maritalStatus;
    }

    public void setMaritalStatus(String s) {
        m_maritalStatus = s;
    }
    public String getSSNP() {
        if (m_ssn == null || "".equals(m_ssn))
            return "";
        if (m_ssn.replaceAll("[ -]", "").length() < 9)
            return "";
        return m_ssn.substring(0, 3) + "-" + m_ssn.substring(3, 5) + "-"
                + m_ssn.substring(5, 9);
    }

    public String getSSN() {
        return m_ssn;
    }

    public void setSSN(String s) {
        if (s != null) {
            s = s.replaceAll("[ -]", "");
            if (s.length() != 9)
                s = null; // Want this?
        }
        m_ssn = s;
    }

    public Date getDOB_Date() {
        return m_dob;
    }
    
    public Date getDOD_Date() {
        return m_dod;
    }
    public String getPlaceOfBirth() {
        return m_placeOfBirth;
    }

    public void setPlaceOfBirth(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_placeOfBirth = s;
    }    
    public String getPlaceOfDeath() {
        return m_placeOfDeath;
    }

    public void setPlaceOfDeath(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_placeOfDeath = s;
    }
    public String getDOB() {
        String sDob = "";
        if (m_dob != null) {
            DateFormat df = DateFormat.getDateInstance(DateFormat.MEDIUM);
            sDob = df.format(m_dob);
        }
        return sDob;
    }

    public String getDOD() {
        String sDob = "";
        if (m_dod != null) {
            DateFormat df = DateFormat.getDateInstance(DateFormat.MEDIUM);
            sDob = df.format(m_dod);
        }
        return sDob;
    }
    
    public String getDOB_VA_Format() {
        String sDob = "";
        Calendar c = Calendar.getInstance();
        if (m_dob != null) {
            c.setTime(m_dob);
            sDob = c.get(Calendar.YEAR) + "";
            String sTmp = c.get(Calendar.MONTH) + 1 + "";
            if (sTmp.length() == 1)
                sTmp = "0" + sTmp;
            sDob += sTmp;
            sTmp = c.get(Calendar.DAY_OF_MONTH) + "";
            if (sTmp.length() == 1)
                sTmp = "0" + sTmp;
            sDob += sTmp;
        }
        return sDob;
    }

    public String getDOD_VA_Format() {
        String sDod = "";
        Calendar c = Calendar.getInstance();
        if (m_dod != null) {
            c.setTime(m_dod);
            sDod = c.get(Calendar.YEAR) + "";
            String sTmp = c.get(Calendar.MONTH) + 1 + "";
            if (sTmp.length() == 1)
                sTmp = "0" + sTmp;
            sDod += sTmp;
            sTmp = c.get(Calendar.DAY_OF_MONTH) + "";
            if (sTmp.length() == 1)
                sTmp = "0" + sTmp;
            sDod += sTmp;
        }
        return sDod;
    }
    
    public String getDOB_SL_Format() {
        String sDob = "";
        if (m_dob != null) {
            sDob = new SimpleDateFormat("MM/dd/yyyy").format(m_dob);
        }
        return sDob;
    }

    public String getDOD_SL_Format() {
        String sDod = "";
        if (m_dod != null) {
            sDod = new SimpleDateFormat("MM/dd/yyyy").format(m_dod);
        }
        return sDod;
    }
    
    public void setDOB(String s) {
        // Exception ex = null;
        m_dob = null;
        try {
            m_dob = oDateFormat.parse(s);
        } catch (Exception e) {
            // ex = e;
        }
        if (m_dob == null) {
            try {
                m_dob = oDateFormat1.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
        if (m_dob == null) {
            try {
                m_dob = oDateSlashFormat.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
        if (m_dob == null) {
            try {
                if (s.length() > 8)
                    s = s.substring(0, 8);
                m_dob = oDateVAFormat.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
//        if (m_dob == null) {
//            SystemLogger.getCHDRLog(PersonIdentityVO.class.getName()).error(
//                    "DOB NOT SET: '" + s + "' did not parse");
//        }
    }
    public void setDOD(String s) {
        // Exception ex = null;
        m_dod = null;
        try {
            m_dod = oDateFormat.parse(s);
        } catch (Exception e) {
            // ex = e;
        }
        if (m_dod == null) {
            try {
                m_dod = oDateFormat1.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
        if (m_dod == null) {
            try {
                m_dod = oDateSlashFormat.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
        if (m_dod == null) {
            try {
                if (s.length() > 8)
                    s = s.substring(0, 8);
                m_dod = oDateVAFormat.parse(s);
            } catch (Exception e) {
                // ex = e;
            }
        }
//        if (m_dod == null) {
//            SystemLogger.getCHDRLog(PersonIdentityVO.class.getName()).error(
//                    "DOD NOT SET: '" + s + "' did not parse");
//        }
    }
    public void setDOB_VA_Format(String d) {
        setDOB(d);
    }
    public void setDOD_VA_Format(String d) {
        setDOD(d);
    }
    public String getVAID() {
        return m_vaId;
    }

    public void setVAID(String s) {
        m_vaId = s;
    }

    public String getAddress1() {
        return m_address1;
    }

    public void setAddress1(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_address1 = s;
    }    
    public String getAddress2() {
        return m_address2;
    }

    public void setAddress2(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_address2 = s;
    }
    public String getAddress3() {
        return m_address3;
    }

    public void setAddress3(String s) {
        if (s != null && s.length() > MAX_NAME_LEN)
            s = s.substring(0, MAX_NAME_LEN - 1);
        m_address3 = s;
    }
    public String getCity() {
        return m_city;
    }    
    public void setCity(String s) {
        m_city = s;
    }
    public String getState() {
        return m_state;
    }   
    public void setState(String s) {
        m_state = s;
    }
    public String getZip() {
        return m_zip;
    }    
    public void setZip(String s) {
        m_zip = s;
    }    
    public String getPhoneNumber() {
        return m_phoneNumber;
    }    
    public void setPhoneNumber(String s) {
        m_phoneNumber = s;
    }
    public String getDODID() {
        return m_dodId;
    }

    public void setDODID(String s) {
        m_dodId = s;
    }

    public String getADC() {
        if (m_adc > 0)
            return ADC_ACTIVE;
        if (m_adc == 0)
            return ADC_INACTIVE;
        return ADC_PENDING;
    }

    // using by batchDisplay.jsp
    public String getADCBatch() {
        String adc = getADC();
        String err = getErrorReceived();
        if (err != null && err.length() == 0)
            err = null;
        if (err != null && !err.equals("Single Match"))
            return err;
        return adc;
    }

    public void setADC(String s) {
        if (ADC_ACTIVE.equals(s.toUpperCase()))
            m_adc = 1;
        else if (ADC_INACTIVE.equals(s.toUpperCase()))
            m_adc = 0;
        else if (ADC_PENDING.equals(s.toUpperCase()))
            m_adc = -1;
    }

    public String getADCSync() {
        if (m_adc > 0) {
            if (m_adc_sync)
                return ADC_SYNC_SYNCHRONIZED;
            return ADC_SYNC_IN_PROGRESS;
        }
        return ADC_SYNC_NA;
    }

    public void setADCSync(String s) {
        m_adc_sync = ADC_SYNC_SYNCHRONIZED.equalsIgnoreCase(s);
    }

    public Long getM_pk() {
        return m_pk;
    }

    public void setM_pk(Long m_pk) {
        this.m_pk = m_pk;
    }

    public Date getDateSynchCompleted() {
        return dateSynchCompleted==null?null:(Date)dateSynchCompleted.clone();
    }

    public void setDateSynchCompleted(Date dateSynchCompleted) {
        this.dateSynchCompleted = dateSynchCompleted==null?null:(Date)dateSynchCompleted.clone();
    }

    public Date getDateSynchStarted() {
        return dateSynchStarted==null?null:(Date)dateSynchStarted.clone();
    }

    public void setDateSynchStarted(Date dateSynchStarted) {
        this.dateSynchStarted = dateSynchStarted==null?null:(Date)dateSynchStarted.clone();
    }

    public String getErrorReceived() {
        return errorReceived;
    }

    public void setErrorReceived(String errorReceived) {
        if (errorReceived != null && errorReceived.length() > MAX_ERR_LEN)
            errorReceived = errorReceived.substring(0, MAX_ERR_LEN - 1);
        this.errorReceived = errorReceived;
    }

    public Date getLastModifiedDate() {
        return lastModifiedDate==null?null:(Date)lastModifiedDate.clone();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate==null?null:(Date)lastModifiedDate.clone();
    }

    public String getPCF() {
        return m_pcf;
    }

    public void setPCF(String m_pcf) {
        this.m_pcf = m_pcf;
    }

    public String getSites() {
        return m_sites;
    }

    public void setSites(String m_sites) {
        this.m_sites = m_sites;
    }

    public String getPersonString() {
        String s = "";
        s = m_prefixName + " " + m_firstName + " " + m_middleInitial + " "
                + m_lastName + " " + m_suffixName + ", " + getSSNP() + " "
                + getDOB() + " " + m_sex + " : " + m_vaId + " / " + m_dodId
                + " [ " + m_pcf + " " + m_sites + " ]";
        return s;
    }

//    public String toString() {
//
//        return super.toString()
//                + StringFormatter
//                        .formatArgsWithCRLF(
//                                "Person Identity",
//                                new String[][] {
//                                        {
//                                                "VAID",
//                                                StringFormatter
//                                                        .toString(getVAID()) },
//                                        {
//                                                "DODID",
//                                                StringFormatter
//                                                        .toString(getDODID()) },
//                                        {
//                                                "ADC",
//                                                StringFormatter
//                                                        .toString(getADC()) },
//                                        {
//                                                "ADC Batch",
//                                                StringFormatter
//                                                        .toString(getADCBatch()) },
//                                        {
//                                                "Synchronization Status",
//                                                StringFormatter
//                                                        .toString(getADCSync()) },
//                                        {
//                                                "Date Sync. Started",
//                                                StringFormatter
//                                                        .toString(getDateSynchStarted()) },
//                                        {
//                                                "Date Sync. Completed",
//                                                StringFormatter
//                                                        .toString(getDateSynchCompleted()) },
//                                        {
//                                                "Last Error Received",
//                                                StringFormatter
//                                                        .toString(getErrorReceived()) },
//                                        {
//                                                "Date Sync. Started",
//                                                StringFormatter
//                                                        .toString(getLastModifiedDate()) },
//                                        {
//                                                "PCF",
//                                                StringFormatter
//                                                        .toString(getPCF()) },
//                                        {
//                                                "Sites",
//                                                StringFormatter
//                                                        .toString(getSites()) }
//
//                                // Add other information here
//                                });
//    }

//    public String toPrintableString() {
//        return "Person: " + StringFormatter.toPrintableString("VAID:", getVAID())
//                + StringFormatter.toPrintableString("/DODID:", getDODID()) 
//                + StringFormatter.toPrintableString("/DBPK:", getM_pk()) +
//                StringFormatter.toPrintableString("/ADC:", getADC());
//    }
}