/* ----------------------------------------------------------------
 * File Name 	: SocketTransceiver.java
 * Authored By	: spawaradmin
 * Created on	: Jan 26, 2009
 * 
 * This is copyrighted software of the United States Federal Government.   
 * Any use must be authorized by the
 * 
 * 	     Department of Veterans Affairs
 * 	     National Health Information Network - (NHIN)
 * 	     
 *
 * Any un-authorized use is strictly prohibited and subject to 
 * legal action.
 * 
 * Purpose	:
 * 
 * 
 * --------------------------------------------------------------------
 *                 M o d i f i c a t i o n   H i s t o r y
 * 
 * Date 	:
 * Author 	:
 * Purpose 	: 
 * 
 * 
 * -------------------------------------------------------------------- 
 */

package gov.va.med.nhin.adapter.utils.datasharing.messaging.transceiver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketTransceiver extends Transceiver
{
	public static Logger logger = LoggerFactory.getLogger(SocketTransceiver.class.getName());

	/** Property key for the host property required by the service. */
	public static final String PROP_HOST = "host";

	/** Property key for the port property required by the service. */
	public static final String PROP_PORT = "port";

	/** Property key for the timeout property by the service. */
	public static final String PROP_TOUT = "timeout";

	/**
	 * Property key for the sending facility property required by the service.
	 */
	public static final String PROP_SFAC = "sendingFacility";

	/**
	 * Property key for the receiving facility property required by the service.
	 */
	public static final String PROP_RFAC = "receivingFacility";

	/**
	 * Property key for the record linking attribute property required by the
	 * service.
	 */
	public static final String PROP_LATT = "recordLinkingAttribute";

	/** Set the default network time out to 10 seconds. */
	public static final int DEFAULT_NETWORK_TIMEOUT = 10000;

	private long endTime;

	protected Socket socket;

	protected Properties serviceProperties;

	protected long getEndTime()
	{
		return endTime;
	}

	protected void setEndTime(long value)
	{
		endTime = value;
	}

	protected void send(String data, OutputStream outStream) throws MessageLLPException
	{
		try
		{
			outStream.write(data.getBytes());
			outStream.flush();
		}
		catch(IOException e)
		{
			throw new MessageLLPException("Send operation failed.");
		}
		if(System.currentTimeMillis() > getEndTime())
		{
			throw new MessageLLPException("Send operation timed out.");
		}
	}

	protected String receive(InputStream inStream, String endMarker, int endMarkerMinPosition) throws MessageLLPException
	{
		StringBuffer buffer = new StringBuffer();
		InputStreamReader reader = new InputStreamReader(inStream);
		int i = 0;
		char[] arr = new char[512];
		while(i != -1 && (buffer.indexOf(endMarker) < endMarkerMinPosition))
		{
			try
			{
				i = reader.read(arr, 0, arr.length);
				if(i > 0)
				{
					buffer.append(arr, 0, i);
				}
			}
			catch(IOException ioe)
			{
				throw new MessageLLPException("Receive operation failed.", ioe);
			}
			if(System.currentTimeMillis() > getEndTime())
			{
				throw new MessageLLPException("Receive operation timed out.");
			}
		}
		return buffer.toString();
	}

	protected void connect() throws MessageLLPException
	{
		disconnect();
		String socketAddr = serviceProperties.getProperty(PROP_HOST);
		int socketPort = Integer.parseInt(serviceProperties.getProperty(PROP_PORT));
		int timeOut = Integer.parseInt(serviceProperties.getProperty(PROP_TOUT));
		long startTime = System.currentTimeMillis();
		setEndTime(startTime + timeOut);

		try
		{
			socket = new Socket();
			InetSocketAddress isoc = new InetSocketAddress(socketAddr, socketPort);
			socket.setSoTimeout(timeOut);
			socket.connect(isoc, DEFAULT_NETWORK_TIMEOUT);
		}
		catch(UnknownHostException e)
		{
			String msg = "Unable to contact remote host at address " + socketAddr + " and port " + socketPort;
			logger.error("connect", e);
			throw new MessageLLPException(msg, e);
		}
		catch(IOException e)
		{ // also SocketTimeoutException
			String msg = "Unable to contact remote host at address " + socketAddr + " and port " + socketPort;
			logger.error("connect", e);
			throw new MessageLLPException(msg, e);
		}
	}

	protected void disconnect()
	{
		if(socket == null)
			return;
		try
		{
			if(socket.isConnected())
			{
				try
				{
					socket.getInputStream().close();
				}
				catch(Exception e1)
				{
				}
				try
				{
					socket.getOutputStream().close();
				}
				catch(Exception e1)
				{
				}
				socket.close();
			}
		}
		catch(IOException e)
		{
			// do nothing
			logger.error("Exception in disconnect", e);
		}
		finally
		{
			socket = null;
		}
	}

	protected InputStream getInputStream() throws MessageLLPException
	{
		if(socket == null || socket.isClosed())
			throw new MessageLLPException("Trancseiver is not connected.");
		try
		{
			return socket.getInputStream();
		}
		catch(IOException e)
		{
			String msg = "Failed to obtain InputStream from Socket.";
			logger.error("getInputStream", e);
			throw new MessageLLPException(msg, e);
		}
	}

	protected OutputStream getOutputStream() throws MessageLLPException
	{
		if(socket == null || socket.isClosed())
			throw new MessageLLPException("Trancseiver is not connected.");
		try
		{
			return socket.getOutputStream();
		}
		catch(IOException e)
		{
			String msg = "Failed to obtain OutputStream from Socket.";
			logger.error("getOutputStream", e);
			throw new MessageLLPException(msg, e);
		}
	}

	protected abstract Object transceive(Object payload) throws MessageLLPException;
}
