package gov.va.med.nhin.adapter.utils.das;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author KazeninP
 */
public class DasDAOHttpImpl implements DasDAO
{
	public static final Logger logger = LoggerFactory.getLogger(DasDAOHttpImpl.class.getName());

	private String endPoint;

	/*
	 * Instantiate DasDAOHttpImpl
	 * 
	 * @param endPoint a VLER DAS URL template.
	 */
	public DasDAOHttpImpl(String endPoint)
	{
		this.endPoint = endPoint;
	}

	/*
	 * Sends HTTP POST request to VLER DAS with Immunization data
	 * 
	 * @param req POJO containing ICN, Facility Number and C32 doc
	 * 
	 * @return response POJO containing Bson Doc Id
	 * 
	 * @throws DasException contains errorCode and codeContext
	 */
	public DasOperationSendImmunizationDataResponse doOperationSendImmunizationData(DasOperationSendImmunizationDataRequest req) throws DasException
	{
		logger.debug("DasDAOHttpImpl", "doOperationSendImmunizationData");

		String errorMsg;

		String icn = req.getICN();
		String facility = req.getFacility();
		byte[] message = req.getMessage();

		/*
		 * WebClient client = WebClient.create(endPoint);
		 * client.header("content-desc", "cda/xml");
		 * 
		 * List<Attachment> atts = new LinkedList<Attachment>(); atts.add(new
		 * Attachment("file", "text/xml", message));
		 * 
		 * MultipartBody body = new MultipartBody(atts, true);
		 * 
		 * Response response = client.post(body);
		 */

		Client client = ClientBuilder.newBuilder().register(MultiPartFeature.class).build();

		WebTarget target = client.target(endPoint);

		FormDataMultiPart multipart = new FormDataMultiPart().field("file", message, MediaType.TEXT_XML_TYPE); // !was
																												// MediaType.APPLICATION_XML_TYPE
		logger.debug("multipart {} = ", multipart);

		Response response = target.request().header("content-desc", "cda/xml").post(Entity.entity(multipart, multipart.getMediaType()));

		logger.debug("HTTP POST response status {} = ", response.getStatus());// CCR
																				// 177986
		logger.debug("HTTP POST response content {}= ", response.toString());

		int httpStatus = response.getStatus();
		String httpReasonPhrase = response.getStatusInfo().getReasonPhrase();

		if(httpStatus == Response.Status.NOT_FOUND.getStatusCode())
		{
			// 404 document not found
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())
		{
			// 500 XDS_REGISTRY_ERROR
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close the response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.BAD_REQUEST.getStatusCode())
		{
			// 400 Bad request
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close the response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.SERVICE_UNAVAILABLE.getStatusCode())
		{
			// 503 XDS_REGISTRY_NOT_AVAILABLE
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close the response");
			}

			throw new DasException("XDSRegistryNotAvailable", errorMsg);
		}
		else if(httpStatus == Response.Status.GATEWAY_TIMEOUT.getStatusCode())
		{
			// 504 XDS_REGISTRY_BUSY
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
			}
			throw new DasException("XDSRegistryBusy", errorMsg);
		}
		else if(httpStatus == Response.Status.CREATED.getStatusCode())
		{
			// 200
			// success - Read and Delete
			logger.debug("successful with a 200");
		}
		else if(httpStatus == Response.Status.OK.getStatusCode())
		{
			// 201
			// success - Create and Update
			logger.debug("successful with a 201");
		}
		else if(httpStatus == Response.Status.NO_CONTENT.getStatusCode())
		{
			// 204
			// success - query returning no data
			logger.debug("successful with a 204");
		}
		else
		{
			// unexpected error from DAS
			errorMsg = "Error executing HTTP POST, ICN = " + icn + ", Facility = " + facility + ", HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close the response");
			}

			throw new DasException("UknownError", errorMsg);
		}

		String responseMessage = response.readEntity(String.class);
		String responseDocId = getDocId(responseMessage);

		logger.debug("Doc ID from VLER DAS response {} = ", responseDocId);

		try
		{
			response.close();
		}
		catch(Exception e)
		{
			throw new DasException("Error occurred while attempting to close response");
		}

		DasOperationSendImmunizationDataResponse res = new DasOperationSendImmunizationDataResponse();
		res.setDocId(responseDocId);
		res.setBsonResponse(responseMessage);

		logger.debug("DasDAOHttpImpl", "doOperationSendImmunizationData");

		return res;
	}

	/*
	 * Sends HTTP POST request to VLER DAS with ACP data
	 * 
	 * @param req POJO containing ICN, ACP doc
	 * 
	 * @return response POJO containing Bson Doc Id
	 * 
	 * @throws DasException contains errorCode and codeContext
	 */
	public DasOperationSendACPDocumentResponse doOperationSendACPDocument(DasOperationSendACPDocumentRequest req) throws DasException
	{
		logger.debug("DasDAOHttpImpl", "doOperationSendACPDocument");

		String errorMsg;

		byte[] message = req.getMessage();

		Client client = ClientBuilder.newBuilder().register(MultiPartFeature.class).build();

		WebTarget target = client.target(endPoint);

		FormDataMultiPart multipart = new FormDataMultiPart();
		FormDataContentDisposition dispo = FormDataContentDisposition//
		.name("file").fileName("SSA_EAuth.xml").size(message.length).build();
		FormDataBodyPart bodypart = new FormDataBodyPart(dispo, message, MediaType.TEXT_XML_TYPE);
		multipart.bodyPart(bodypart);

		Response response = target.request().header("content-desc", "cda/xml")
		// .header("Content-Disposition", "form-data; name=\"file\";
		// filename=\"Joe Patient C62.xml\"")
		.post(Entity.entity(multipart, multipart.getMediaType()));

		// Response response = target.request().post(Entity.entity(message,
		// MediaType.APPLICATION_XML));

		// Client client = ClientBuilder.newBuilder()
		// .register(MultiPartFeature.class)
		// .build();
		//
		// WebTarget target = client.target(endPoint);
		//
		// FormDataMultiPart multipart = new FormDataMultiPart()
		// .field("file", message, MediaType.TEXT_XML_TYPE); //!was
		// MediaType.APPLICATION_XML_TYPE
		//
		// logger.log(Level.INFO, "multipart = {0}", multipart.toString());
		//
		// Response response = target.request()
		// .header("content-desc", "cda/xml")
		// .post(Entity.entity(multipart, multipart.getMediaType()));

		logger.debug("HTTP POST response status = {}", response.getStatus());
		logger.debug("HTTP POST response content = {}", response.toString());

		int httpStatus = response.getStatus();
		String httpReasonPhrase = response.getStatusInfo().getReasonPhrase();

		if(httpStatus == Response.Status.NOT_FOUND.getStatusCode())
		{
			// 404 document not found
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error(errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attemptign to close response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())
		{
			// 500 XDS_REGISTRY_ERROR
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error(errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attempting to close response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.BAD_REQUEST.getStatusCode())
		{
			// 400 Bad request
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attemptign to close response");
			}

			throw new DasException("XDSRegistryError", errorMsg);
		}
		else if(httpStatus == Response.Status.SERVICE_UNAVAILABLE.getStatusCode())
		{
			// 503 XDS_REGISTRY_NOT_AVAILABLE
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attemptign to close response");
			}

			throw new DasException("XDSRegistryNotAvailable", errorMsg);
		}
		else if(httpStatus == Response.Status.GATEWAY_TIMEOUT.getStatusCode())
		{
			// 504 XDS_REGISTRY_BUSY
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error("Error occurred: ", errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attemptign to close response");
			}

			throw new DasException("XDSRegistryBusy", errorMsg);
		}
		else if(httpStatus == Response.Status.CREATED.getStatusCode())
		{
			// 200
			// success - Read and Delete
		}
		else if(httpStatus == Response.Status.OK.getStatusCode())
		{
			// 201
			// success - Create and Update
		}
		else if(httpStatus == Response.Status.NO_CONTENT.getStatusCode())
		{
			// 204
			// success - query returning no data
		}
		else
		{
			// unexpected error from DAS
			errorMsg = "Error executing HTTP POST, HTTP Error " + httpStatus + ": " + httpReasonPhrase;
			logger.error(errorMsg);

			try
			{
				response.close();
			}
			catch(Exception e)
			{
				throw new DasException("Error occurred while attemptign to close response");
			}

			throw new DasException("UknownError", errorMsg);
		}

		String responseMessage = response.readEntity(String.class);
		String responseDocId = getDocId(responseMessage);

		logger.debug("Doc ID from VLER DAS response = {}", responseDocId);

		try
		{
			response.close();
		}
		catch(Exception e)
		{
		}

		DasOperationSendACPDocumentResponse res = new DasOperationSendACPDocumentResponse();

		res.setDocId(responseDocId);
		res.setBsonResponse(responseMessage);

		logger.debug("DasDAOHttpImpl", "doOperationSendACPDocument");

		return res;
	}

	private String getDocId(String response)
	{
		String docId;

		logger.debug("Received BSON response from VLER DAS {} :\n" + response);

		// don't parse, just position at ObjectID( to save time
		int beg = response.indexOf("ObjectID(") + 9;
		if(beg < 0)
		{
			return "";
		}

		int end = response.indexOf(")", beg);
		if(end < 0)
		{
			return "";
		}
		docId = response.substring(beg, end);

		return docId;
	}
}