package gov.va.med.nhin.adapter.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import gov.va.med.nhin.adapter.utils.config.ObjectFactory;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;

/**
 *
 * @author David Vazquez
 */
public class PropertiesCollectionFactory
{
	static private final Map<String, Properties> propertiesCollectionMap = new HashMap<String, Properties>();

	static public synchronized Properties getPropertiesCollection(String filename) throws Exception
	{
		Properties ret = propertiesCollectionMap.get(filename);
		if(ret == null)
		{
			ret = loadPropertiesCollection(filename);
			propertiesCollectionMap.put(filename, ret);
		}

		return ret;
	}

	static private Properties loadPropertiesCollection(String filename) throws Exception
	{
		PropertiesType propertiesType = XMLUtils.load(filename, PropertiesType.class);
		return loadProperties(propertiesType);
	}

	static private Properties loadProperties(PropertiesType propertiesType)
	{
		Properties ret = new Properties();
		for(PropertyType propertyType : propertiesType.getProperty())
		{
			if(!NullChecker.isNullOrEmpty(propertyType.getValue()))
			{
				ret.setProperty(propertyType.getName(), propertyType.getValue());
			}
			else
			{
				ret.put(propertyType.getName(), loadProperties(propertyType.getProperties()));
			}
		}

		return ret;
	}

	static public void storeProperties(String filename, Properties properties) throws Exception
	{
		PropertiesType propertiesType = unloadProperties(properties);
		XMLUtils.save(filename, new ObjectFactory().createProperties(propertiesType));
	}

	static private PropertiesType unloadProperties(Properties properties)
	{
		PropertiesType propertiesType = new PropertiesType();

		for(Map.Entry entry : properties.entrySet())
		{
			String key = (String) entry.getKey();
			Object value = entry.getValue();
			PropertyType propertyType = new PropertyType();

			propertyType.setName(key);
			if(value instanceof String)
			{
				propertyType.setValue(value.toString());
			}
			else
			{
				propertyType.setProperties(unloadProperties((Properties) value));
			}

			propertiesType.getProperty().add(propertyType);
		}

		return propertiesType;
	}

	static private synchronized void removeFromCache(String filename)
	{
		propertiesCollectionMap.remove(filename);
	}
}
