package gov.va.med.nhin.adapter.mvi.hl7parsers;

import java.util.Map;

import org.hl7.v3.PNExplicit;
import org.hl7.v3.PRPAIN201301UV02;
import org.hl7.v3.PRPAMT201301UV02Person;

import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author SRA International, Inc.
 */
public class HL7Parser201301
{
	public static String extractMothersMaidenName(PRPAMT201301UV02Person person)
	{
		String result = null;
		PNExplicit mmn = extractPatientPersonName(person, "C");
		if(mmn != null)
		{
			Map<String, String> nameMap = HL7Parser201306.parseNames(mmn.getContent());
			if(nameMap != null)
			{
				result = nameMap.get("nameFamily");
			}
		}
		return result;
	}

	public static Map extractPatientLegalName(PRPAMT201301UV02Person person)
	{
		PNExplicit name = extractPatientPersonName(person, "L");
		return HL7Parser201306.parseNames(name.getContent());
	}

	public static PNExplicit extractPatientPersonName(PRPAMT201301UV02Person person, String useCodeParam)
	{
		PNExplicit result = null;
		if(person != null && NullChecker.isNotNullOrEmpty(person.getName()))
		{
			result = HL7Parser201306.extractPatientPersonName(person.getName(), useCodeParam);
		}

		return result;
	}

	public static String extractRemoteAssigningAuthorityID(PRPAIN201301UV02 message)
	{
		String aaID = null;

		if(message.getControlActProcess() != null && message.getControlActProcess().getAuthorOrPerformer() != null && message.getControlActProcess().getAuthorOrPerformer().size() > 0 && message.getControlActProcess().getAuthorOrPerformer().get(0) != null && message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice() != null && message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue() != null && message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId() != null && message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().size() > 0 && message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0) != null && NullChecker.isNotNullOrEmpty(message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot()))
		{
			aaID = message.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().getId().get(0).getRoot();
		}
		return aaID;
	}

}