package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;
import gov.va.med.nhin.adapter.datamanager.*;

public class YesNoDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(YesNoDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        String yesValue = translation.getProperty("yesValue");
        String noValue = translation.getProperty("noValue");

        // Anything that doesn't satisfy the YES condition will return "NO"
        // Code structure is to allow for easy modification for different failure function
        try {
            if (input != null && input instanceof String) {
                if (((String)input).equals(yesValue)) {
                    ret = "YES";
                } else if (((String)input).equals(yesValue)) {
                    ret = "NO";
                } else {
                    ret = "NO";
                }
            } else {
                ret = "NO";
            }
        }
        catch (Throwable t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
