package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplate;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplateFactory;

/**
 *
 * @author David Vazquez
 */
public class XMLTemplateDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Object ret = null;

		if(input != null)
		{
			String configFilename = translation.getProperty("configFilename");

			XMLTemplate xmlTemplate = XMLTemplateFactory.getXMLTemplate(configFilename);
			ret = xmlTemplate.fillIn(input);
		}

		return ret;
	}
}
