package gov.va.med.nhin.adapter.datamanager.translators;

import java.beans.XMLEncoder;
import java.io.FileOutputStream;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author VHAISBVAZQUD
 */
public class XMLBeanEncoderDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		if(input != null)
		{
			try
			{
				String path = translation.getProperty("path");
				FileOutputStream fos = new FileOutputStream(path);
				XMLEncoder xmlEncoder = new XMLEncoder(fos);
				xmlEncoder.writeObject(input);
				xmlEncoder.close();
			}
			catch(Throwable t)
			{
				throw new DataManagerException("An error occurred.", t);
			}
		}

		return input;
	}
}
