package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;

/**
 *
 * @author David Vazquez
 */
public class SizeDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Integer ret = null;

		try
		{
			if(!NullChecker.isNullOrEmpty(input) && Utils.isCollection(input))
			{
				ret = Utils.getCollectionLength(input);
			}
		}
		catch(Exception e)
		{
			throw new DataManagerException("SizeDataTranslator exception", e);
		}

		return ret;
	}
}
