/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class RaceSplitDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        String[] ret = null;
        
        if (input != null) {
            if (!(input instanceof String)) {
                throw new DataManagerException("input must be of type java.lang.String.");
            }

            String delimiter = translationType.getProperty("delimiter");
            String startIndex = translationType.getProperty("startIndex");
            String endIndex = translationType.getProperty("endIndex");
            ret = ((String)input).split(delimiter);
            int start, end;

            if (NullChecker.isNotNullOrEmpty(startIndex)) {
                start = Integer.parseInt(startIndex);
            }
            else {
                start = 0;
            }

            if (NullChecker.isNotNullOrEmpty(endIndex)) {
                end = Integer.parseInt(endIndex);
                if (end < 0) {
                    end = ret.length + end;
                }
            }
            else {
                end = ret.length;
            }

            if (start < end && (start != 0 || end != ret.length)) {
                ret = Arrays.copyOfRange(ret, start, end);
            }
        }
        
        List<Object> results = new ArrayList<Object>();
        for (String r : ret) {
        	SmartHashMap shm = new SmartHashMap();
        	String s[] = r.split("\\^");
        	if (s.length == 3) {
        		shm.put("raceCode", s[2]);
            	shm.put("raceDisplay",s[1]);
        	}
        	
        	results.add(shm);
        }
        
        return results;
    }
}
