package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class PrefixDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
	{
		String prefix = translationType.getProperty("prefix");

		if(NullChecker.isNullOrEmpty(prefix))
		{
			throw new DataManagerException("Property prefix is required.");
		}

		return prefix + (NullChecker.isNotNullOrEmpty(input) ? input.toString() : "");
	}
}
