package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class NotFilterDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(NotFilterDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        String whereProperty = translation.getProperty("whereProperty");
        String wherePropertyValue = translation.getProperty("wherePropertyValue");
        
        logger.log(Level.FINEST, "whereProperty={0}", whereProperty);
        logger.log(Level.FINEST, "wherePropertyValue={0}", wherePropertyValue);
        
        logger.log(Level.FINEST, "input={0}", input.toString());
        logger.log(Level.FINEST, "input class={0}", input.getClass());

        try {
            if (input != null) {
                if (!Utils.isCollection(input)) {
                    if (input instanceof SmartHashMap) {
                        List<Object> objList = new ArrayList<Object>();
                        
                        Object value = PropertyUtils.getProperty(input, whereProperty);
                        logger.log(Level.FINEST, "value={0}", value);
                        if (NullChecker.isNullOrEmpty(value)
                                || !value.equals(wherePropertyValue)) {
                            objList.add(input);
                        }
                        
                        return objList;
                    } else {
                        throw new RuntimeException("input must be a collection.");
                    }
                }

                List<Object> objList = new ArrayList<Object>();
                for (int i = 0;  i < Utils.getCollectionLength(input);  ++i) {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    Object value = PropertyUtils.getProperty(obj, whereProperty);
                    logger.log(Level.FINEST, "value={0}", value);
                    if (NullChecker.isNullOrEmpty(value)
                            || !value.equals(wherePropertyValue)) {
                        objList.add(obj);
                    }
                }
                
                ret = objList;
            }
        }
        catch (RuntimeException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (IllegalAccessException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (InvocationTargetException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (NoSuchMethodException t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
