/*******************************************************************************
 * Copyright (c) 2014 MuirS.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     MuirS - initial API and implementation
 *     
 *******************************************************************************/
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.results.AllergiesType;
import gov.va.med.nhin.adapter.results.AllergyType;
import gov.va.med.nhin.adapter.results.StringValueType;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

/**
 * @author MuirS
 *
 */
public class NKATranslation implements gov.va.med.nhin.adapter.datamanager.DataParser
{
	private static final String NOTDONE = "not done";
	private static final String NKA = "NKA";
	private static final String ASSESSMENT = "assessment";

	private String getAssessment(Object allergy)
	{

		String nka = "";

		try
		{
			Object okna = PropertyUtils.getProperty(allergy, ASSESSMENT);
			if(okna != null)
			{

				if(okna instanceof StringValueType)
				{
					nka = ((StringValueType) okna).getValue();
				}
				else

				if(okna instanceof String)
				{
					nka = (String) okna;
				}
				else
				{
					nka = okna.toString();
				}
			}
		}
		catch(Exception e)
		{

		}
		return nka;
	}

	/*
	 * 
	 * NKATranslation walks the allergies results to determine if all of the
	 * allergy entries returned from VPR are No Known Allergies - If they are
	 * return one allergy with all the facilities If not, return the original
	 * list (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.nhin.adapter.datamanager.DataTranslator#translate(java.lang.
	 * Object, java.lang.Object, gov.va.med.nhin.adapter.datamanager.Reference,
	 * gov.va.med.nhin.adapter.datamanager.DataQuery)
	 */

	private boolean assess(AllergiesType allergies, String assessment)
	{

		for(Object oo : allergies.getAllergy())
		{
			if(oo instanceof AllergyType)
			{
				AllergyType at = (AllergyType) oo;
				if(!assessment.equalsIgnoreCase(getAssessment(at)))
				{
					return false;
				}
			}

		}

		return true;

	}

	public List parse(List results, Reference parser, DataQuery dataQuery)
	{

		for(Object result : results)
		{
			if(result instanceof gov.va.med.nhin.adapter.results.ResultsType)
			{
				gov.va.med.nhin.adapter.results.ResultsType resultsType = (gov.va.med.nhin.adapter.results.ResultsType) result;
				for(Object o : resultsType.getResults())
				{
					if(o instanceof AllergiesType)
					{
						AllergiesType allergies = (AllergiesType) o;
						if(!assess(allergies, NKA) && !assess(allergies, NOTDONE))
						{
							for(Object oo : allergies.getAllergy())
							{
								AllergyType at = (AllergyType) oo;
								at.setAssessment(new StringValueType());
							}
						}
					}
				}
			}

		}
		return results;
	}

}
