package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class HL7ToURIPhoneNumberDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		final String HL7_PHONE_REGEX = "(\\d{1,3})?([-\\(]?\\d{3}[-\\)]?)(\\d{3})-?(\\d{4})(X\\d{1,5})?";
		final String BLANK = "";

		String ret;

		if(!NullChecker.isNullOrEmpty(input))
		{
			Pattern pattern = Pattern.compile(HL7_PHONE_REGEX);
			Matcher matcher = pattern.matcher((String) input);
			if(matcher.matches())
			{
				ret = "tel:";
				if(!NullChecker.isNullOrEmpty(matcher.group(1)))
				{
					ret += "+" + matcher.group(1);
				}
				else
				{
					ret += "+1";
				}

				if(!NullChecker.isNullOrEmpty(matcher.group(2)))
				{
					Pattern pattern2 = Pattern.compile("\\d{3}");
					Matcher matcher2 = pattern2.matcher(matcher.group(2));
					if(matcher2.find())
					{
						ret += "-" + matcher2.group() + "-";
					}
				}

				ret += matcher.group(3) + "-" + matcher.group(4);

				if(!NullChecker.isNullOrEmpty(matcher.group(5)))
				{
					ret += ";ext=" + matcher.group(5).substring(1);
				}
			}
			else
			{
				ret = "tel:" + input + ";phone-context=domain";
			}
		}
		else
		{
			ret = BLANK;
		}

		return ret;
	}
}
