package gov.va.med.nhin.adapter.datamanager.translators;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import gov.va.med.nhin.adapter.datamanager.DataDate;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class FileManDateDataTranslator implements DataTranslator
{
	static private final String DATE_FORMAT = "yyyyMMddHHmmss";

	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		DataDate ret = null;

		if(input != null)
		{
			if(!(input instanceof java.math.BigDecimal))
			{
				throw new DataManagerException("input must be of type java.math.BigDecimal");
			}

			String targetDateFormat = translation.getProperty("targetDateFormat");

			if(!NullChecker.isNullOrEmpty(targetDateFormat))
			{
				if(!DATE_FORMAT.startsWith(targetDateFormat))
				{
					throw new RuntimeException("targetDateFormat is invalid.");
				}
			}
			else
			{
				targetDateFormat = DATE_FORMAT;
			}

			String s = fixFileManDate((BigDecimal) input);

			String datePattern = DATE_FORMAT.substring(0, s.length());

			SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
			try
			{
				Date d = formatter.parse(s);
				ret = new DataDate(d.getTime(), targetDateFormat.substring(0, Math.min(s.length(), targetDateFormat.length())));
			}
			catch(Exception e)
			{
				throw new DataManagerException("There was an error parsing the date.", e);
			}
		}

		return ret;
	}

	private String fixFileManDate(BigDecimal fileManDate)
	{
		String ret;
		double d = fileManDate.doubleValue() + 17000000;
		DecimalFormat formatter = (DecimalFormat) DecimalFormat.getNumberInstance();
		formatter.applyPattern("00000000.######");
		ret = formatter.format(d);

		int dotIndex = ret.indexOf(".");
		if(dotIndex == -1)
		{
			while(ret.endsWith("00"))
			{
				ret = ret.substring(0, ret.length() - 2);
			}
		}
		else
		{
			if((ret.length() - 9) % 2 != 0)
			{
				ret += "0";
			}

			ret = ret.substring(0, dotIndex) + ret.substring(dotIndex + 1);
		}

		return ret;
	}
}
