package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.results.ExposuresType;
import gov.va.med.nhin.adapter.utils.*;
import java.lang.reflect.InvocationTargetException;

public class ExposureCompilationDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(ExposureCompilationDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        
        // Default exposures to 0
        ExposuresType expType = new ExposuresType();
        expType.setAo("0");
        expType.setCv("0");
        expType.setHnc("0");
        expType.setMst("0");
        expType.setPgulf("0");
        expType.setRad("0");

        try {
            if (input != null) {
                logger.log(Level.FINEST, "input={0}", input.toString());
                logger.log(Level.FINEST, "input class={0}", input.getClass());
                
                if (!Utils.isCollection(input)) {
                    if (input instanceof SmartHashMap) {
                        Object value = PropertyUtils.getProperty(input, "value");
                        logger.log(Level.FINEST, "value={0}", value);
                        
                        if (value.equals("AO")) {
                            expType.setAo("1");
                        } else if (value.equals("CV")) {
                            expType.setCv("1");
                        } else if (value.equals("HNC")) {
                            expType.setHnc("1");
                        } else if (value.equals("MST")) {
                            expType.setMst("1");
                        } else if (value.equals("PG")) {
                            expType.setPgulf("1");
                        } else if (value.equals("IR")) {
                            expType.setRad("1");
                        }
                        
                        ret = expType;
                        return ret;
                    } else {
                        throw new RuntimeException("Input must be a collection.");
                    }
                }

                for (int i = 0;  i < Utils.getCollectionLength(input);  ++i) {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    Object value = PropertyUtils.getProperty(obj, "value");
                    logger.log(Level.FINEST, "value={0}", value);
                    
                    if (value.equals("AO")) {
                        expType.setAo("1");
                    } else if (value.equals("CV")) {
                        expType.setCv("1");
                    } else if (value.equals("HNC")) {
                        expType.setHnc("1");
                    } else if (value.equals("MST")) {
                        expType.setMst("1");
                    } else if (value.equals("PG")) {
                        expType.setPgulf("1");
                    } else if (value.equals("IR")) {
                        expType.setRad("1");
                    }
                }
            }
            ret = expType;
        }
        catch (RuntimeException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (IllegalAccessException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (InvocationTargetException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (NoSuchMethodException t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
