package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author serverchmarc
 *
 *         Performs all the additional filtering based on the
 *         AdditionalParameters passed.
 *
 */
public class CreateSectionFromList implements DataTranslator
{
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String sectionFromName = (String) translation.getProperty("sectionFrom");
		String listFromName = (String) translation.getProperty("listFrom");
		String sectionToName = (String) translation.getProperty("sectionTo");

		if(StringUtils.isBlank(sectionToName) || StringUtils.isBlank(listFromName) || StringUtils.isBlank(sectionFromName))
		{
			throw new DataManagerException("sectionTo,  listFrom and sectionFrom property must be set.");
		}

		SmartHashMap rootMap;

		if(input instanceof SmartHashMap)
		{
			rootMap = (SmartHashMap) input;
		}
		else
		{
			throw new DataManagerException("Incoming data is not a Map.");
		}

		List<SmartHashMap> fromSection = (List<SmartHashMap>) rootMap.get(sectionFromName);

		if(CollectionUtils.isNotEmpty(fromSection))
		{
			for(SmartHashMap map : fromSection)
			{
				Object fromObj = map.get(listFromName);
				if(fromObj != null)
				{
					if(rootMap.containsKey(sectionToName))
					{
						rootMap.put(sectionToName, fromObj);
					}
					else
					{
						if(fromObj instanceof List)
						{
							rootMap.put(sectionToName, fromObj);
						}
						else
						{
							List<Object> list = new ArrayList<Object>();
							list.add(fromObj);
							rootMap.put(sectionToName, list);
						}
					}
				}
			}
		}

		return input;
	}
}
