package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

import org.apache.commons.lang3.StringEscapeUtils;

/**
 *
 * @author serverchmarc
 */
public class ConcatenateAndXMLEscapeDataTranslator extends ConcatenateDataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Object ret = super.translate(input, result, translation, dataQuery);

		// Special case where values need to be escaped.
		if(ret instanceof String)
		{
			ret = StringEscapeUtils.escapeXml((String) ret);
		}

		return ret;
	}
}
