package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

/**
 * @author serverchmarc
 *
 *         Class will copy items from one section to another. This overcomes
 *         limitations in the mapping files when additional data is needed.
 * 
 *         This does everything in place.
 *
 */
public class CombineDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String fromName = translation.getProperty("fromData");
		String toName = translation.getProperty("toData");

		if(StringUtils.isBlank(fromName) || StringUtils.isBlank(toName))
		{
			throw new DataManagerException("fromData and toData property must be set.");
		}

		try
		{
			Object fromData = PropertyUtils.getProperty(input, fromName);
			String key;

			if(StringUtils.contains(fromName, "\\."))
			{
				// Only need the final keyname for mapping purposes.
				key = fromName.substring(fromName.lastIndexOf("\\."));
			}
			else
			{
				key = fromName;
			}

			if(fromData != null)
			{
				if(StringUtils.contains(toName, "*"))
				{
					// We need to add the item to every base object in the list,
					// this assumes a list is returned.
					int index = StringUtils.lastIndexOf(toName, ".");
					String listName = toName.substring(0, index);
					Object toListObj = PropertyUtils.getProperty(input, listName);
					if(toListObj instanceof List)
					{
						// We are at the right place.
						List<SmartHashMap> toList = (List<SmartHashMap>) toListObj;
						for(SmartHashMap map : toList)
						{
							map.put(key, fromData);
						}
					}
				}
				else
				{
					// Just add information to single Object.
					Object toData = PropertyUtils.getProperty(input, toName);
					if(toData != null && toData instanceof SmartHashMap)
					{
						SmartHashMap map = (SmartHashMap) toData;
						map.put(key, fromData);
					}
				}
			}
		}
		catch(IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch(InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch(NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return input;
	}
}
