package gov.va.med.nhin.adapter.datamanager.translators;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;

/**
 *
 * @author David Vazquez
 */
public class CollectionToStringDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;

		if(input != null)
		{
			if(!Utils.isCollection(input))
			{
				throw new DataManagerException("input must be a collection");
			}

			ret = "";
			String property = translation.getProperty("property");
			String separator = StringEscapeUtils.unescapeHtml4(translation.getProperty("separator"));

			String count = StringEscapeUtils.unescapeHtml4(translation.getProperty("count"));
			int maxObjects = Utils.getCollectionLength(input);
			if(NullChecker.isNotNullOrEmpty(count) && StringUtils.isNumeric(count))
			{
				int ctr = Integer.valueOf(count);
				if(maxObjects > ctr - 1)
				{
					maxObjects = ctr;
				}

			}

			for(int i = 0; i < maxObjects; ++i)
			{
				String str = null;

				try
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);
					if(obj != null)
					{
						if(NullChecker.isNotNullOrEmpty(property))
						{
							obj = PropertyUtils.getProperty(obj, property);
							if(obj != null)
							{
								str = obj.toString();
							}
						}
						else
						{
							str = obj.toString();
						}
					}
				}
				catch(Throwable t)
				{
					throw new DataManagerException("An error occurred retrieving item from collection.", t);
				}

				if(StringUtils.isNotBlank(str))
				{
					if(i > 0 && NullChecker.isNotNullOrEmpty(separator))
					{
						ret += separator;
					}
					ret += str;
				}
			}
		}

		return ret;
	}
}
