package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author 575914
 */
public class AssessmentTotalTranslator implements DataTranslator {

    static private final Logger logger = Logger.getLogger(AssessmentTotalTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        String fields = translation.getProperty("fields");

        Object ret = null;

        try {
            int total = 0;
            int i = 0;
            for (String field : fields.split(",")) {
                try {
                    Object value = translation.getValue(field);
                    total += Integer.parseInt((String)value);
                } catch (Exception e) {
                    logger.log(Level.FINEST, "Field {0} is not an integer: {1}", new Object[]{i, e});
                }
                
                i++;
            }

            ret = String.valueOf(total);
            
        } catch (RuntimeException t) {
            throw new DataManagerException("There was an error.", t);
        } finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
