package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AssessmentDateAddDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(AssessmentDateAddDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        String admittedName = translation.getProperty("admittedDate");
        String dischargedName = translation.getProperty("dischargedDate");
        DataDate admitted = (DataDate)translation.getValue(admittedName);
        DataDate discharged = (DataDate)translation.getValue(dischargedName);
        DataDate admittedRaw = (DataDate)translation.getValue("admitted");
        DataDate dischargedRaw = (DataDate)translation.getValue("discharged");

        try {
            if (input != null) {
                if (!Utils.isCollection(input)) {
                    
                    if (input instanceof SmartHashMap) {
                        List<Object> objList = new ArrayList<Object>();
                        
                        String type = (String)PropertyUtils.getProperty(input, "assessmentType");
                        
                        if (type.equalsIgnoreCase("admission") || type.equalsIgnoreCase("goals") || 
                                type.equalsIgnoreCase("interim")) {
                            PropertyUtils.setProperty(input, "assessmentDate", admitted);
                            PropertyUtils.setProperty(input, "assessmentDateRaw", admittedRaw);
                        } else {
                            PropertyUtils.setProperty(input, "assessmentDate", discharged);
                            PropertyUtils.setProperty(input, "assessmentDateRaw", dischargedRaw);
                        }
                        
                        objList.add(input);
                        
                        logger.exiting(getClass().getName(), "translate", ret);
                        return objList;
                    } else {
                        throw new RuntimeException("input must be a collection.");
                    }
                }

                List<Object> objList = new ArrayList<Object>();
                for (int i = 0;  i < Utils.getCollectionLength(input);  i++) {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    String type = (String)PropertyUtils.getProperty(obj, "assessmentType");
                    
                    if (type.equalsIgnoreCase("admission") || type.equalsIgnoreCase("goals") || 
                            type.equalsIgnoreCase("interim")) {
                        PropertyUtils.setProperty(obj, "assessmentDate", admitted);
                    } else {
                        PropertyUtils.setProperty(obj, "assessmentDate", discharged);
                    }
                    
                    objList.add(obj);
                }
                
                ret = objList;
            }
        }
        catch (RuntimeException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (IllegalAccessException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (InvocationTargetException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (NoSuchMethodException t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
