package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.logging.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class AppendAllDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(AppendAllDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        String whereProperty = translation.getProperty("whereProperty");

        try {
            if (input != null) {
                if (!Utils.isCollection(input)) {
                    throw new RuntimeException("input must be a collection.");
                }

                String appendString = "";
                for (int i = 0;  i < Utils.getCollectionLength(input);  ++i) {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    
                    if (obj instanceof ArrayList) {
                        for (int j = 0;  j < Utils.getCollectionLength(obj);  ++j) {
                            Object listObj = PropertyUtils.getIndexedProperty(obj, "", j);
                            Object value = PropertyUtils.getProperty(listObj, whereProperty);

                            if (NullChecker.isNotNullOrEmpty(value)) {
                                appendString = appendString + (String)value;
                            }
                        }
                    } else {
                        Object value = PropertyUtils.getProperty(obj, whereProperty);

                        if (NullChecker.isNotNullOrEmpty(value)) {
                            appendString = appendString + (String)value;
                        }
                    }
                }
                
                ret = appendString;
            }
        }
        catch (RuntimeException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (IllegalAccessException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (InvocationTargetException t) {
            throw new DataManagerException("There was an error.", t);
        } catch (NoSuchMethodException t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
