package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class NotEqualsDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filter, DataQuery dataQuery)
	{
		try
		{
			String text = filter.getProperty("text");
			String fieldName = filter.getProperty("fieldName");
			String value = BeanUtils.getProperty(result, fieldName);

			return !value.equals(text);
		}
		// CCR 1779231
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred processing filter.", e);
		}
	}
}
