package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.Comparator;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class MatchDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		boolean ret = true;
		String[] matchFields = dataQuery.getParameterNames();

		try
		{
			for(String matchField : matchFields)
			{
				Object leftValue = dataQuery.getParameter(matchField);
				Object rightValue = PropertyUtils.getProperty(result, matchField);

				if(!NullChecker.isNullOrEmpty(leftValue) && dataQuery.isResult(matchField) && !Comparator.equals(leftValue, rightValue))
				{
					ret = false;
					break;
				}
			}
		}
		catch(Exception e)
		{
			ret = false;
		}

		return ret;
	}
}
