package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class IsNotNullDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			String valueName = filterType.getProperty("valueName");
			Object value = PropertyUtils.getProperty(result, valueName);
			return !NullChecker.isNullOrEmpty(value);
		}
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred when processing filter.", e);
		}
	}
}
