package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;
import java.util.Properties;

import org.apache.commons.beanutils.BeanUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.PropertiesCollectionFactory;

/**
 *
 * @author David Vazquez
 */
public class FacilityNumberDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			String connectionFilename = filterType.getProperty("connectionFilename");
			String facilityNumberName = filterType.getProperty("facilityNumberName");
			Properties propertiesCollection = PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
			String facilityNumber = BeanUtils.getProperty(result, facilityNumberName);
			return !NullChecker.isNullOrEmpty(facilityNumber) && propertiesCollection.containsKey(facilityNumber);
		}
		catch(Exception e)
		{
			throw new DataManagerException("An error occurrend when processing filter.", e);
		}
	}
}
