package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.Comparator;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class ExtendedMatchDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		boolean ret = true;
		String queryName = filterType.getProperty("queryName");
		DataManager dataManager = dataQuery.getDataManager();
		DataQuery dq = dataManager.getQuery(queryName);
		fillParameters(result, dq);
		List dqResults = dq.getResults();

		if(!dqResults.isEmpty())
		{
			String[] matchFields = dataQuery.getParameterNames();
			try
			{
				for(String matchField : matchFields)
				{
					Object leftValue = dataQuery.getParameter(matchField);
					Object rightValue = PropertyUtils.getProperty(dqResults.get(0), matchField);

					if(!NullChecker.isNullOrEmpty(leftValue) && dq.isResult(matchField) && !Comparator.equals(leftValue, rightValue))
					{
						ret = false;
						break;
					}
				}
			}
			catch(Exception e)
			{
				ret = false;
			}
		}
		else
		{
			ret = false;
		}

		return ret;
	}

	private void fillParameters(Object result, DataQuery dataQuery)
	{
		String[] paramNames = dataQuery.getParameterNames();

		for(String paramName : paramNames)
		{
			Object value = null;
			try
			{
				value = PropertyUtils.getProperty(result, paramName);
			}
			// CCR1779231
			catch(Exception e)
			{
				throw new DataManagerException("ExtendedMatchDataFilter-there was an error during a filter test.", e);
			}
			if(!NullChecker.isNullOrEmpty(value))
			{
				dataQuery.setParameter(paramName, value);
			}
		}
	}
}
