package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.Date;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class DateBetweenDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		boolean ret = false;

		try
		{
			String beginDateName = filterType.getProperty("beginDateName");
			String endDateName = filterType.getProperty("endDateName");
			String valueName = filterType.getProperty("valueName");
			String includeEndDateString = filterType.getProperty("includeEndDate");
			Date beginDate = (Date) dataQuery.getParameter(beginDateName);
			Date endDate = (Date) dataQuery.getParameter(endDateName);
			Date value = (Date) PropertyUtils.getProperty(result, valueName);
			boolean includeEndDate = NullChecker.isNotNullOrEmpty(includeEndDateString) && includeEndDateString.toUpperCase().equals("TRUE");

			ret = (NullChecker.isNullOrEmpty(beginDate) || value.equals(beginDate) || value.after(beginDate)) && (NullChecker.isNullOrEmpty(endDate) || includeEndDate && value.equals(endDate) || value.before(endDate));
		}
		catch(Exception e)
		{
			throw new DataManagerException("There was an error during a filter test.", e);
		}

		return ret;
	}
}
