package gov.va.med.nhin.adapter.datamanager.filters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

public class ContainsDataFilter implements DataFilter
{
	private static final Logger logger = LoggerFactory.getLogger(ContainsDataFilter.class.getName());

	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			String valueName = filterType.getProperty("valueName");
			String containsString = filterType.getProperty("containsString");
			String value = BeanUtils.getProperty(result, valueName);

			logger.debug("valueName: {}", valueName);
			logger.debug("value: {}", value);
			logger.debug("containsString: {}", containsString);

			boolean doesContain = value.toUpperCase().contains(containsString);
			logger.debug("doesContain: {}", doesContain);

			return doesContain;
		}
		// CCR 177821-code improvement
		catch(IllegalAccessException | InvocationTargetException | NoSuchMethodException t)
		{
			throw new RuntimeException("An error occurred when processing filter.", t);
		}
	}
}
