package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class AndDataFilter implements DataFilter
{
	private static final Logger logger = LoggerFactory.getLogger(AndDataFilter.class.getName());

	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			String firstOperand = filterType.getProperty("firstOperand");
			String secondOperand = filterType.getProperty("secondOperand");

			logger.debug("firstOperand: {} secondOperand: {}", firstOperand, secondOperand);

			return firstOperand.toUpperCase().equals("TRUE") && secondOperand.toUpperCase().equals("TRUE");
		}
		catch(Throwable t)
		{
			throw new RuntimeException("An error occurred when processing filter.", t);
		}
	}
}
