package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.PropertiesCollectionFactory;

/**
 *
 * @author David Vazquez
 */
public class VistAAggregatorDataAdapter implements DataAdapter
{
	private static final Logger logger = LoggerFactory.getLogger(VistAAggregatorDataAdapter.class.getName());
	
	public List getData(DataQuery dataQuery)
	{
		List ret = new ArrayList<Map>();
		HashMap<String, List> result = new HashMap<String, List>();

		ret.add(result);

		try
		{
			DataManager dataManager = dataQuery.getDataManager();
			String mpiQueryName = dataQuery.getProperty("MPIQueryName");
			String facilityNumberName = dataQuery.getProperty("facilityNumberName");
			String patientIdFieldName = dataQuery.getProperty("patientIdFieldName");
			String patientIdQueryFieldName = dataQuery.getProperty("patientIdQueryFieldName");
			String connectionFilename = dataQuery.getProperty("connectionFilename");
			Properties propertiesCollection = PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);

			logger.debug("properties Collection {} ", propertiesCollection);
			
			// query the MPI for facilities where the patient is known.
			DataQuery mpiQuery = dataManager.getQuery(mpiQueryName);

			// fill in parameters.
			for(String parameterName : dataQuery.getParameterNames())
			{
				if(mpiQuery.isParameter(parameterName))
				{
					mpiQuery.setParameter(parameterName, dataQuery.getParameter(parameterName));
				}
			}

			List<Map> mpiResults = mpiQuery.getResults();

			// query each facility for data.
			for(Map mpiResult : mpiResults)
			{
				String facilityNumber = (String) mpiResult.get(facilityNumberName);
				if(facilityNumber != null)
				{
					Properties pc = (Properties) propertiesCollection.get(facilityNumber);
					if(pc != null)
					{
						// get the patient's id.
						String patientId = (String) mpiResult.get(patientIdFieldName);
						// add the id of the user at the local facilities to the
						// query.
						dataQuery.setParameter(patientIdQueryFieldName, patientId);

						// iterate over each of the queries that will be invoked
						// at this facility.
						String[] vamcQueryNames = dataQuery.getProperty("VAMCQueryNames").split(",");
						for(String vamcQueryName : vamcQueryNames)
						{
							DataQuery vamcQuery = dataManager.getQuery(vamcQueryName);

							vamcQuery.setProperty("connection", facilityNumber);

							// fill in parameters.
							for(String parameterName : dataQuery.getParameterNames())
							{
								if(vamcQuery.isParameter(parameterName))
								{
									vamcQuery.setParameter(parameterName, dataQuery.getParameter(parameterName));
								}
							}

							List vamcResults = vamcQuery.getResults();

							if(!vamcResults.isEmpty())
							{
								List storedVamcResults = result.get(vamcQueryName);
								if(storedVamcResults == null)
								{
									result.put(vamcQueryName, vamcResults);
								}
								else
								{
									storedVamcResults.addAll(vamcResults);
								}
							}
						}
					}
				}
			}
		}
		catch(Throwable t)
		{
			throw new DataManagerException("An error occurred when geting data.", t);
		}

		return ret;
	}
}
