package gov.va.med.nhin.adapter.datamanager.adapters;

import com.sun.xml.ws.client.BindingProviderProperties;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.datasharing.system.exception.ApplicationRuntimeException;
import gov.va.oit.oed.vaww.VAIdMPort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

import org.hl7.v3.ActClassControlAct;
import org.hl7.v3.CS;
import org.hl7.v3.II;
import org.hl7.v3.ObjectFactory;
import org.hl7.v3.PRPAIN201309UV02;
import org.hl7.v3.PRPAIN201309UV02QUQIMT021001UV01ControlActProcess;
import org.hl7.v3.PRPAIN201310UV02;
import org.hl7.v3.PRPAMT201307UV02ParameterList;
import org.hl7.v3.PRPAMT201307UV02PatientIdentifier;
import org.hl7.v3.PRPAMT201307UV02QueryByParameter;
import org.hl7.v3.ST;
import org.hl7.v3.XActMoodIntentEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author VACOGRAYD1
 */
public class MVI1309DataAdapter extends MVIDataAdapter implements DataAdapter
{
	private static final Logger logger = LoggerFactory.getLogger(MVI1309DataAdapter.class.getName());

	public List getData(DataQuery dataQuery)
	{
		initializeProperties(dataQuery);

		ArrayList ret = new ArrayList();
		PRPAIN201310UV02 response1310 = null;

		String icn = (String) dataQuery.getParameter("icn");
		AssertionType assertion = (AssertionType) dataQuery.getParameter("assertion");
		String sendingFacilityOID = (String) dataQuery.getParameter("sendingFacilityOID");
		String sendingFacilityNumber = (String) dataQuery.getParameter("sendingFacilityNumber");

		// Implement a requirement to retry the operation on failure, up to a
		// retry limit
		int retriesRemaining = mviRetryLimit;
		while(true)
		{
			try
			{
				PRPAIN201309UV02 request1309 = buildRequest1309(icn, assertion, sendingFacilityOID, sendingFacilityNumber);
				logger.debug("1309 Request: {} ", request1309);
				VAIdMPort port = getVAIdMPort(wsdlURL);
				Map<String, Object> requestContext = ((BindingProvider) port).getRequestContext();
				requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, mviRequestTimeout);
				requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, mviConnectTimeout);
				response1310 = (PRPAIN201310UV02) port.prpaIN201309UV02(request1309);

				logger.debug("1310 Response: {} ", response1310);

				break;
			}
			catch(SOAPFaultException sfe)
			{
				String msg = sfe.getMessage();
				String sfStr = sfe.getFault().getFaultString();
				String sfCode = sfe.getFault().getFaultCode();
				logger.debug("SOAPFaultException:  Message {} '" + msg + "'; FaultString {} '" + sfStr + "'; FaultCode {} '" + sfCode + "'");
				throw new ApplicationRuntimeException(sfe);
			}
			catch(WebServiceException ste)
			{
				logger.error("WebServiceException connecting to MVI.  Message={}", ste.getMessage());
				// only execute retries on timeout
				if(ste.getCause() instanceof java.net.SocketTimeoutException)
				{
					if(--retriesRemaining == 0)
					{
						throw new WebServiceException(ste);
					}
					else
					{
						logger.error("Retrying connection to MVI due to SocketTimeoutException. {} retries remaining.", retriesRemaining);
					}
				}
				else
				{
					throw new WebServiceException(ste);
				}
			}
			// CCR 179231
			catch(Exception e)
			{
				// CCR 177986
				logger.error("There was an error getting data from MVI {} ", e);
				throw new DataAdapterException("There was an error getting data from MVI", e);
			}
		}

		ret.add(response1310);

		return ret;
	}

	/*
	 * Build 1309 request
	 * 
	 * @param String icn
	 * 
	 * @param AssertionType assertion
	 */
	private PRPAIN201309UV02 buildRequest1309(String icn, AssertionType assertion, String sendingFacilityOID, String sendingFacilityNumber)
	{

		ObjectFactory objFactory = new ObjectFactory();
		PRPAIN201309UV02 request1309 = objFactory.createPRPAIN201309UV02();

		// Set up message header fields
		request1309.setITSVersion(request1309.getITSVersion()); // "XML_1.0"

		request1309.setId(createMessageId(request1309.getId()));

		// Set Creation Time
		request1309.setCreationTime(createCreationTime());

		// Set InteractionId
		II interactionId = new II();
		interactionId.setRoot("2.16.840.1.113883.1.6"); // HL7Constants.INTERACTION_ID_ROOT
		interactionId.setExtension("PRPA_IN201309UV02");
		request1309.setInteractionId(interactionId);

		// Set Processing Code
		CS processingCode = new CS();
		processingCode.setCode(processingCodeStr);
		request1309.setProcessingCode(processingCode);

		// Set Procesing Mode
		CS processingModeCode = new CS();
		processingModeCode.setCode("T");
		request1309.setProcessingModeCode(processingModeCode);

		// Set Acknowlegment Code
		CS acceptAckCode = new CS();
		acceptAckCode.setCode("AL");
		request1309.setAcceptAckCode(acceptAckCode);

		// Set Receiver
		request1309.getReceiver().add(createReceiver());

		// Set Sender
		request1309.setSender(createSender(mviSiteKey1309, sendingFacilityOID, sendingFacilityNumber));

		// Create ControlActProcess
		PRPAIN201309UV02QUQIMT021001UV01ControlActProcess controlActProcess = objFactory.createPRPAIN201309UV02QUQIMT021001UV01ControlActProcess();
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		controlActProcess.setClassCode(ActClassControlAct.CACT);

		// Set DataEnterer
		controlActProcess.getDataEnterer().add(createDataEnterer2(assertion));

		// Query By Parameter
		PRPAMT201307UV02QueryByParameter queryByParameter = new PRPAMT201307UV02QueryByParameter();
		JAXBElement<PRPAMT201307UV02QueryByParameter> queryByParameterJAXB = objFactory.createPRPAIN201309UV02QUQIMT021001UV01ControlActProcessQueryByParameter(queryByParameter);

		II queryId = new II();
		queryId.setRoot(VA_OID); // taken from MVI_Service_Description.PDF doc
		queryId.setExtension("33452"); // taken from MVI_Service_Description.PDF
										// doc
		queryByParameter.setQueryId(queryId);

		CS queryPriorityCode = new CS();
		queryPriorityCode.setCode("I");
		queryByParameter.setResponsePriorityCode(queryPriorityCode);

		CS queryStatusCode = new CS();
		queryStatusCode.setCode("new");
		queryByParameter.setStatusCode(queryStatusCode);

		// Parameter List
		PRPAMT201307UV02ParameterList parameterList = new PRPAMT201307UV02ParameterList();

		PRPAMT201307UV02PatientIdentifier patientIdentifier = new PRPAMT201307UV02PatientIdentifier();

		ST semanticsText = new ST();
		semanticsText.setValue("Patient.Id");
		patientIdentifier.setSemanticsText(semanticsText);

		II patientId = new II();
		patientId.setRoot(VA_OID); // taken from the MVI_Service_Description.PDF
									// doc
		patientId.setExtension(icn + "^NI"); // ICN + "^NI"
		patientIdentifier.getValue().add(patientId);

		parameterList.getPatientIdentifier().add(patientIdentifier);
		queryByParameter.setParameterList(parameterList);

		controlActProcess.setQueryByParameter(queryByParameterJAXB);

		request1309.setControlActProcess(controlActProcess);

		// CCR 177986-logging update
		logger.debug("1309 request {} ", request1309);

		return request1309;
	}
}